<?php $__env->startSection('content'); ?>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;"><i class="fa fa-search"></i> Select Criteria
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            
                            <form action="" id="search">
                                <div class="row">

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                                From Date
                                            </label>
                                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                                <input type="text" name="from_date" value="<?php echo e($start->format('m/d/y')); ?>"
                                                    class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchFrom"
                                                    autocomplete="off">

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                                To Date
                                            </label>
                                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                                <input type="text" name="to_date" value="<?php echo e($end->format('m/d/y')); ?>"
                                                    class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" >
                                                Select Head
                                            </label>
                                            <select name="expenseHead" id="expenseHead" class="form-control select2 form-control-sm" required>
                                                <option value="all" selected>ALL head</option>
                                                <?php $__currentLoopData = $expenseHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group float-right mt-2">

                                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                                    class="fa fa-search"></i> Search</button>
                                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            
                            <br>
                            <div class="col-md-12" id="result">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <!-- page script -->

<?php $__env->stopPush(); ?>

<?php $__env->startSection('ajax'); ?>
    <script type="text/javascript">
        //console.log('error');
        $(document).ready(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('expenseSearchResult')); ?>',
                    data: $('#search').serialize(),
                    // alert(result);
                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();

                    }
                });
            });
            //alert(result);
            $('#details').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '<?php echo e(route('expenseSearchResult')); ?>',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                    }
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/powermedia/radius-circle/resources/views/accounts/expenseReport/index.blade.php ENDPATH**/ ?>