<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-body">

            <form action="<?php echo e(route('cash-in-hand', request()->segment(3))); ?>" method="get" id="search">
                <?php echo method_field('get'); ?>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input value="<?php echo e($start->format('m/d/y')); ?>" type="text" name="from_date" class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input value="<?php echo e($end->format('m/d/y')); ?>" type="text" name="to_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>


                    <div class="col-md-4">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>

                        </div>
                    </div>


                </div>




            </form>

            <div class="table-responsive">

                <?php if($type == 'all'): ?>
                    <table class="table" style="width:100%">
                        <thead style="width:100%">
                            <tr>
                                <th class="bg-dark">Name</th>
                                <th class="bg-dark">Opening Balance</th>
                                <th class="bg-dark">Received Amount</th>
                                <th class="bg-dark">Paid Amount</th>
                                <th class="bg-dark">Balance</th>
                                <th class="bg-dark">Action</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td>CASH</td>
                                <td> <?php echo e($cash['cash_opening'] ?? 0); ?></td>
                                <td class="bg-light"><?php echo e($cash['cash_received'] ?? 0); ?></td>
                                <td class=""><?php echo e(abs($cash['cash_paid'] ?? 0)); ?></td>
                                <td class="bg-light">
                                    <?php echo e(($cash['cash_opening'] ?? 0) + ($cash['cash_received'] ?? 0) + ($cash['cash_paid'] ?? 0)); ?>

                                </td>
                                <td class="">
                                    <a href="<?php echo e(route('cash-in-hand', 'cash')); ?>" class="btn btn-primary"><i
                                            class="fa fa-eye"></i></a>
                                </td>
                            </tr>
                            
                            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($d['email'] != 'soiket@outlook.com' && $d['email'] != 'support@yetfix.com' && $d['email'] != 'rokibulhasan.356@gmail.com' && $d['email'] != 'admin@billingfix.xyz'): ?>
                                    <tr>
                                        <td><?php echo e($d['name']); ?></td>
                                        <td> <?php echo e($d['op_balance'] ?? 0); ?></td>
                                        <td class="bg-light"><?php echo e($d['ramount'] ?? 0); ?></td>
                                        <td class=""><?php echo e($d['pamount'] ?? 0); ?></td>
                                        <td class="bg-light">
                                            <?php echo e(($d['op_balance'] ?? 0) + ($d['ramount'] ?? 0) - ($d['pamount'] ?? 0)); ?></td>
                                        <td class="">
                                            <a href="<?php echo e(route('view_user_account_history', $d['user_id'])); ?>"
                                                class="btn btn-primary"><i class="fa fa-eye"></i></a>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr style="display: none">
                                <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                                <td class="bg-secondary" class="bg-light"></td>
                                <td class="bg-secondary"></td>
                                <td class="bg-secondary">
                                    
                                </td>
                                <td class="bg-secondary"></td>
                            </tr>
                        </tbody>
                    </table>
                <?php elseif($type == 'cash'): ?>
                    <div class="table-responsive">

                        <table class="table" style="width:100%">
                            <thead style="width:100%">
                                <tr>
                                    <th class="bg-dark">Date</th>
                                    <th class="bg-dark">Particulars</th>
                                    <th class="bg-dark">Received Amount</th>
                                    <th class="bg-dark">Paid Amount</th>
                                    <th class="bg-dark">Balance</th>
                                    <th class="bg-dark">Remarks/Narration</th>
                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td class="bg-light"></td>
                                    <td class="">Opening Balance:</td>
                                    <td class="bg-light"><?php echo e($cash['cash_opening']); ?></td>
                                    <td class=""></td>
                                </tr>

                                <?php
                                    $tr = 0;
                                    $tp = 0;
                                ?>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($d->created_at); ?></td>
                                        <td><?php echo e($d->note); ?></td>
                                        <td class="bg-light">
                                            <?php if($d->amount > 0): ?>
                                                <?php ($tr += $d->amount); ?> <?php echo e($d->amount); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="">
                                            <?php if($d->amount < 0): ?>
                                                <?php ($tp += abs($d->amount)); ?> <?php echo e(abs($d->amount)); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="bg-light"></td>
                                        <td class=""></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                                    <td class="bg-secondary" class="bg-light"><?php echo e($tr); ?></td>
                                    <td class="bg-secondary"><?php echo e($tp); ?></td>
                                    <td class="bg-secondary">
                                        <?php echo e($tr + $cash['cash_opening'] - $tp); ?>

                                    </td>
                                    <td class="bg-secondary"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>


            </div>

            <div id="app" style="display: none">
                <table class="table" style="width:100%;display:none" v-show="true">
                    <thead style="width:100%">
                        <tr>
                            <th class="bg-dark">Name</th>
                            <th class="bg-dark">Opening Balance</th>
                            <th class="bg-dark">Received Amount</th>
                            <th class="bg-dark">Paid Amount</th>
                            <th class="bg-dark">Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr v-for="cash in data">
                            <td>{{ cash.name }}</td>
                            <td>{{ cash.op_balance }}</td>
                            <td v-model.number="item.ramount" class="bg-light">{{ cash.ramount }}</td>
                            <td class="" v-model.number="item.pamount">{{ cash.pamount }}</td>
                            <td class="bg-light"> </td>
                        </tr>
                        <tr>
                            <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                            <td class="bg-secondary" class="bg-light"></td>
                            <td class="bg-secondary"></td>
                            <td class="bg-secondary">
                                
                            </td>
                            <td class="bg-secondary"></td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('ajax'); ?>
    <script src="https://cdn.jsdelivr.net/npm/vue@2.6.14"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.24.0/axios.min.js"
        integrity="sha512-u9akINsQsAkG9xjc1cnGF4zw5TFDwkxuc9vUp5dltDWYCSmyd0meygbvgXrlc/z7/o4a19Fb5V0OUE58J7dcyw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                data: [],
                item: {
                    'ramount': '',
                    'pamount': '',
                    'op_balance': ''
                }

            },
            computed: {
                // subtotal:function(){
                //   return this.data.accounts.reduce((item) => {
                //     return parseInt(item.ramount)+parseInt(item.op_balance)-parseInt(item.pamount);
                //   },0)
                // }
            },
            mounted() {
                axios.get('<?php echo e(route('cash_in_hand_api')); ?>')
                    .then(response => {
                        console.log(response.data);
                        this.data = response.data.data;
                    });
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/powermedia/radius-circle/resources/views/report/cash_in_hand.blade.php ENDPATH**/ ?>