<?php

namespace App\Http\Controllers;

use App\Models\Banking;
use App\Models\BankTransfar;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class BankingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bankings = Banking::paginate(20);

        foreach ($bankings as $banking) {
            $total_deposit = BankTransfar::where('account_id', $banking->id)->sum('diposit_amount');
            $total_withdrawal = BankTransfar::where('account_id', $banking->id)->sum('withdraw_amount');

            $balance = $banking->opening_balance + $total_deposit - $total_withdrawal;

            $banking->balance = $balance;
        }

        return view("banking.index", [
            "bankings" => $bankings,
            'page_title' => "Bank Account List",
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view("banking.create", [
            'page_title' => "Bank Account Registration",
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'account_name' => 'required',
            'account_no' => 'required',
            'bank_name' => 'required',
            'branch_name' => 'required',
            'status' => 'required',
            'opening_balance' => 'required',
        ]);
        $banking = new Banking();
        $banking->account_name = $request->account_name;
        $banking->account_no = $request->account_no;
        $banking->bank_name = $request->bank_name;
        $banking->branch_name = $request->branch_name;
        $banking->status = $request->status;
        $banking->opening_balance = $request->opening_balance;
        $banking->save();

        Toastr::success('Bank Account Created Successfully', 'Success');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Banking  $banking
     * @return \Illuminate\Http\Response
     */
    public function show(Banking $banking)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Banking  $banking
     * @return \Illuminate\Http\Response
     */
    public function edit(Banking $banking)
    {
        return view("banking.edit", [
            "banking" => $banking,
            'page_title' => "Bank Account Edit",
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Banking  $banking
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Banking $banking)
    {
        $request->validate([
            'account_name' => 'required',
            'account_no' => 'required',
            'bank_name' => 'required',
            'branch_name' => 'required',
            'status' => 'required',
            'opening_balance' => 'required',
        ]);
        $banking = Banking::find($banking->id);
        $banking->account_name = $request->account_name;
        $banking->account_no = $request->account_no;
        $banking->bank_name = $request->bank_name;
        $banking->branch_name = $request->branch_name;
        $banking->status = $request->status;
        $banking->opening_balance = $request->opening_balance;
        $banking->save();

        Toastr::success('Bank Account Updated Successfully', 'Success');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Banking  $banking
     * @return \Illuminate\Http\Response
     */
    public function destroy(Banking $banking)
    {
        $banking = Banking::find($banking->id);
        $banking->delete();
        Toastr::success('Bank Account Deleted Successfully', 'Success');
        return redirect()->back();
    }

    public function approve($id)
    {
        $banking = Banking::find($id);

        $banking->action = 1;
        $banking->save();

        Toastr::success('Bank Account Approved Successfully', 'Success');
        return redirect()->back();
    }

}
