<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-primary">
                        <div class="card-header bg-light">

                            <h3 class="card-title" style="color:#115548;">Edit Expense</h3>
                            <div class="card-tools">
                                <a href="<?php echo e(route('expense.index')); ?>"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;See List</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        
                        <!-- form start -->
                        <form method="POST" action="<?php echo e(route('expense.update', $model->id)); ?>"
                            enctype="multipart/form-data" name="editForm">
                            <?php echo method_field('put'); ?>
                            <?php echo csrf_field(); ?>

                            <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Name*
                                    </label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter Name"
                                        value="<?php echo e($model->name); ?>" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Expense Head*
                                    </label>
                                    <select name="expenseHead" class="form-control" required>
                                        <option value="">Select One</option>
                                        <?php $__currentLoopData = $expenseHead; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="employee_id">Employee</label>
                                    <select name="employee_id" class="form-control">
                                        <option value="">Select One</option>
                                        <?php $__currentLoopData = getEmployesInExpense(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php echo e($item->id == $model->employee_id ? 'selected' : ''); ?>><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Invoice Number*
                                    </label>
                                    <input type="text" name="invoice_number" class="form-control"
                                        placeholder="Enter Invoice Number" value="<?php echo e($model->invoice_number); ?>" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Date*
                                    </label>
                                    <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                        <input type="text" placeholder="Enter Date" name="date" value="<?php echo e(date('m/d/Y',strtotime($model->date))); ?>"
                                            class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                            data-target="#searchFrom" autocomplete="off" >

                                    </div>

                                </div>

                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Amount*
                                    </label>
                                    <input type="number" step=".01" name="amount" class="form-control" placeholder="Enter Amount" value="<?php echo e($model->amount); ?>" required>
                                </div>
                                <div class="form-group col-md-4">

                                    <label for="Attachment" class="control-label">Upload Documents</label>
                                    <input placeholder="Upload Attachment" class="form-control" name="attach_document"
                                        type="file" autocomplete="off">
                                         <?php if(!empty($model->attach_document)): ?>
                                            <?php
                                                $isS3 = checkSettings('store_image_to_s3') === 'enable';
                                                $imgUrl = $isS3
                                                    ? $model->attach_document // already full URL from S3
                                                    : asset('storage/expenseDocument/' . $model->attach_document); // local path
                                            ?>

                                            <img src="<?php echo e($imgUrl); ?>" width="auto" height="100" alt="Document">
                                        <?php else: ?>
                                            <p style="margin-inline: 10px">No File</p>
                                        <?php endif; ?>


                                    <?php if($model->attach_document != null): ?>

                                        <input type="hidden" name="id" value="<?php echo e($model->id); ?>">
                                    <?php else: ?>
                                        <input type="hidden" name="id" value="<?php echo e($model->id); ?>">
                                    <?php endif; ?>

                                </div>

                                <div class="form-group col-md-12">
                                    <label for="shortname">
                                        Description*
                                    </label>
                                    <textarea name="description" class="form-control"
                                        placeholder="Type Description"> <?php echo e($model->description); ?></textarea>
                                </div>
                            </div>
                                <div class="form-group float-right">
                                    <button type="submit" name="btn" class=" btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>
            <!-- /.row -->

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
    <script>
        document.forms['editForm'].elements['expenseHead'].value = <?php echo e($model->expenseHead); ?>

    </script>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-bottom'); ?>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/powermedia/radius-circle/resources/views/accounts/expense/edit.blade.php ENDPATH**/ ?>