<?php $__env->startSection('body'); ?>
    <?php echo $__env->make('Customer.left-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>Profile</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('customerDashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Profile</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
        <section class="section profile">
            <div class="row">

                <div class="col-xl-4">

                    <div class="card">
                        <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">

                            <img src="<?php echo e(asset('niceAdmin/assets/img/profile-img.jpg')); ?>" alt="Profile"
                                class="rounded-circle">
                            <h2>Name: <?php echo e($details['userinfo']->clientsinfo->clients_name); ?></h2>
                            <h3>Profile: <?php echo e($details['package']->package_name); ?></h3>
                            <h3>Status:
                                <?php if($details['userinfo']->clients_status == 'expired'): ?>
                                    <button class="btn-danger"><?php echo e($details['userinfo']->clients_status); ?></button>
                                <?php else: ?>
                                    <button class="btn-primary"><?php echo e($details['userinfo']->clients_status); ?></button>
                                <?php endif; ?>
                            </h3>
                        </div>
                    </div>

                </div>
                <div class="col-xl-8">

                    <div class="card">
                        <div class="card-body pt-3">
                            <!-- Bordered Tabs -->

                            <div class="tab-content pt-2">

                                <div class="tab-pane fade show active profile-overview" id="profile-overview">
                                    <h5 class="card-title">Profile Details</h5>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label ">Full Name</div>
                                        <div class="col-lg-9 col-md-8">
                                            <?php echo e($details['userinfo']->clientsinfo->clients_name); ?></div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Subscriber ID</div>
                                        <div class="col-lg-9 col-md-8"><?php echo e($details['userinfo']->id); ?></div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Username</div>
                                        <div class="col-lg-9 col-md-8"><?php echo e($details['userinfo']->userid); ?></div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">PACKAGE NAME</div>
                                        <div class="col-lg-9 col-md-8"><?php echo e($details['package']->package_name); ?></div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">STATUS</div>
                                        <div class="col-lg-9 col-md-8">
                                            <?php if($details['userinfo']->clients_status == 'expired'): ?>
                                                <button
                                                    class="btn-danger"><?php echo e($details['userinfo']->clients_status); ?></button>
                                            <?php else: ?>
                                                <button
                                                    class="btn-primary"><?php echo e($details['userinfo']->clients_status); ?></button>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">PACKAGE PRICE</div>
                                        <div class="col-lg-9 col-md-8"><?php echo e($details['package']->package_rate); ?></div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">CURRENT BALANCE</div>
                                        <div class="col-lg-9 col-md-8">
                                            <?php if(isset($details['account']->dueAmount) && $details['account']->dueAmount < 1): ?>
                                                <?php echo e(abs($details['account']->dueAmount)); ?>

                                            <?php else: ?>
                                                0
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">Due Balance</div>
                                        <div class="col-lg-9 col-md-8">
                                            <?php if(isset($details['account']->dueAmount) && $details['account']->dueAmount > 0): ?>
                                                <span class="text-red-600 font-bold">
                                                    <?php echo e(abs($details['account']->dueAmount)); ?> </span>
                                            <?php else: ?>
                                                0
                                            <?php endif; ?>
                                        </div>
                                    </div>


                                    <div class="row">
                                        <div class="col-lg-3 col-md-4 label">EXPIRE DATE</div>
                                        <div class="col-lg-9 col-md-8">
                                            <?php echo e(date('d-M-Y', strtotime($details['userinfo']->expire_date))); ?></div>
                                    </div>



                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>

                </div>


            </div>
        </section>

    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Customer.customer-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/gravity2/radius-circle/resources/views/Customer/customer_account.blade.php ENDPATH**/ ?>