@extends('layout.app')
@section('content')
    <form action="{{ route('box.update', $box->id) }}" method="POST">
        @method('PUT')
        @csrf

        <div class="card">
            <div class="card-body">
                <div class="row">
                <div class="form-group col-md-4">
                    <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                        Manager*
                    </label>
                    <select class="select2 form-control" name="manager_id" id="reseller">
                        <option value="">Select One</option>
                        @foreach ($reseller as $item)
                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                        @endforeach
                    </select>
                    @error('reseller_id')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4">
                    <label> Select POP </label>
                    <select name="pop_id" id="pop" class="select2 form-control ">
                        <option value="all"> Select One</option>
                    </select>
                </div>

                <div class="form-group col-md-4">
                    <label for="area" class="block text-sm font-medium text-gray-700">
                        Box*
                    </label>
                    <input type="text" name="box_name" id="box" class="form-control" placeholder="box name"
                        value="{{ $box->box_name }}" autocomplete="off" required>
                    @error('area')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>
            </div>

        </div>

    </form>
@endsection


@section('ajax')
    <script type="text/javascript">
        window.setTimeout(function() {
            window.location.reload();
        }, 100000);

        $(function() {

            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
