<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class userAccountSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        for($i=0;$i<=500;$i++){

            if($i%5==0){
                $paid = rand(200,4000);
                $receive = 0;
            }else{
                $paid = 0;
                $receive = rand(100,2000);
            }

            $user_id = rand(1,2);
            $day = Carbon::today()->subDays(rand(0, 365));

            $id = DB::table('user_accountings')->insertGetId([
                'received_amount' => $receive,
                'paid_amount' => $paid,
                'actions' => 'Seeder value test vy randome',
                'user_id' => $user_id,
                'created_at' => $day
            ]);

            if($paid >0 ){
                DB::table('fund_transfers')->insert([
                    'fund_send_by' => $user_id,
                    'fund_received_by' => 0,
                    'note' => 'payment transfered',
                    'amount' => $paid,
                    'user_accountings_id' => $id,
                    'created_at' => $day
                ]);
            }

        }


        
    }
}