<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientSummariesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_summaries', function (Blueprint $table) {
            $table->id();
            $table->string('month_year');
            $table->decimal('total_clients');
            $table->decimal('total_active_clients');
            $table->decimal('total_expire_clients');
            $table->decimal('total_disable_clients');
            $table->decimal('total_de_active_clients');
            $table->decimal('total_close_clients');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_summaries');
    }
}
