<div class="card" id="serarchReport">
    <div class="card-body">

        <button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>

        <div class=" float-right d-flex amount-container" style="text-align:center; gap:3px !important; ">

            <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_client"> Total Row:
                {{ $bill_generates->count() }}</p>
            <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_amount">Total Bill:
                {{ number_format($bill_generates->sum('bill_amount'), 2, '.', '') }}</p>
            <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_paid">Total Paid:
                {{ number_format($bill_generates->sum('paid_amount'), 2, '.', '') }}</p>
            <p class="p-1 " style="border:2px solid #fed7aa; " id="total_bill_account_due">Total Due:
                {{ number_format($bill_generates->sum('bill_amount') - $bill_generates->sum('paid_amount'), 2, '.', '') }}
            </p>

        </div>

        <div id="result">
            <table class="table table-striped table-borderless table-condensed" id="result_table">
                <thead>
                    <tr class="bg-black">
                        <th>Date</th>
                        <th>Client User Id</th>
                        <th>Client Name</th>
                        <th>Type</th>
                        <th class="text-right">Bill</th>
                        <th class="text-right">Paid</th>
                        <th class="text-right">Due</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($bill_generates as $bill)
                        <tr @if ($bill->clients->deleted_at != null) class = "bg-warning" @endif>
                            <td>{{ $bill->created_at->format('M d Y') }}</td>
                            <td>{{ $bill->clients->userid }}</td>
                            <td>{{ $bill->clientsinfo->clients_name }}</td>
                            <td>{{ $bill->billing_type }}</td>
                            <td class="text-right">{{ $bill->bill_amount }}</td>
                            <td class="text-right">{{ $bill->paid_amount }}</td>
                            <td class="text-right">{{ $bill->bill_amount - $bill->paid_amount }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td><strong>Total Row</strong></td>
                        <td><strong>{{ $bill_generates->count() }}</strong></td>
                        <td></td>
                        <td><strong>Total Amount</strong></td>
                        <td class="text-right">
                            <strong>{{ number_format($bill_generates->sum('bill_amount'), 2, '.', '') }}</strong>
                        </td>
                        <td class="text-right">
                            <strong>{{ number_format($bill_generates->sum('paid_amount'), 2, '.', '') }}</strong>
                        </td>
                        <td class="text-right">
                            <strong>{{ number_format($bill_generates->sum('bill_amount') - $bill_generates->sum('paid_amount'), 2, '.', '') }}</strong>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
