@extends('layout.app')



@section('content')
    <div class="card">

        <div class="card-body">

            <form action="{{ route('pgw-response-log-search') }}"  method="POST">
                @csrf

                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                    From Date
                                </label>
                                <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                    <input type="text" name="from_date" class="form-control datetimepicker-input input-group-append"
                                        data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                                </div>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                    To Date
                                </label>
                                <div class="input-group date" id="searchTo" data-target-input="nearest">
                                    <input type="text" name="to_date"  class="form-control datetimepicker-input input-group-append"
                                        data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-12">
                            <button type="submit" class="btn btn-primary float-right">
                                Search
                            </button>
                        </div>

                    </div>




            </form>

            <div class="table-responsive">
                <table  class="display table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th style="max-width: 80px;">Date</th>
                            <th style="max-width: 80px;">Status/Source</th>
                            <th style="max-width: 150px;">Payment Ref Id</th>
                            <th style="max-width: 100px;">Error Massage</th>

                            <th style="max-width: 80px;">Payment Method/Payment For</th>

                            <th style="max-width: 80px;">Name</th>
                            <th style="max-width: 300px;">Response</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-300">
                        @foreach ($logs as $log)
                            <tr>
                                <td style="max-width: 80px;">{{ $log->created_at }}</td>
                                <td style="max-width: 80px;">
                                    <span class="badge @if ($log->status == "Failed") badge-danger   @elseif ($log->status == "Success") badge-success  @else badge-warning @endif" > {{ $log->status }}/{{$log->source}} </span>
                                </td>
                                <td style="max-width: 150px;">{{ $log->payment_ref_id }}</td>
                                <td style="max-width: 100px;">{{ $log->error_massage }}</td>
                                <td style="max-width: 80px;">{{ $log->payment_method }}/{{ $log->payment_for }}</td>
                                <td style="max-width: 80px;">{{get_name($log->user_id,$log->payment_for)}}</td>
                                <td style="max-width: 300px;">{{ $log->response }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


@endsection



    @section('ajax')
        <script>
            $(function() {



            });
        </script>
    @endsection

