<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubResellerRechargeReport extends Model
{
    use HasFactory;

    protected $table = 'sub_reseller_recharge_report';

    protected $guarded = [];
    
    public function reseller()
    {
        return $this->hasOne(Reseller::class,'id','reseller_id');
    }

    public function user(){
        return $this->hasOne(User::class,'id','user_id');
    }

    public function balance()
    {
        return $this->hasMany(Balance::class,'type_id','reseller_id')->whereType('reseller');
       
    }

    public function pop()
    {
        return $this->belongsTo(Pop::class,'pop_id','id');
    }
}
