<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">

            <form action="<?php echo e(route('view_user_account_history_search', $id)); ?>" method="post" id="searchFix">
                <?php echo csrf_field(); ?>
                <?php echo method_field('post'); ?>
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input value="<?php echo e($start->format('m/d/y')); ?>" type="text" name="from_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input value="<?php echo e($end->format('m/d/y')); ?>" type="text" name="to_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <?php if(checkSettings('account-history-userName-search') == 'enable'): ?>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="userName" placeholder="userName">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>


                    <div class="col-md-3">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtnFix"><i
                                    class="fa fa-search"></i> Search</button>

                        </div>
                    </div>


                </div>




            </form>

            <div class="table-responsive">
                <h5>Total = <?php echo e($accounts->count()); ?></h5>

                <table class="table" style="width:100%">
                    <thead style="width:100%">
                        <tr>
                            <th class="bg-dark">Date</th>
                            <th class="bg-dark">Particulars</th>
                            <th class="bg-dark">Received Amount</th>
                            <th class="bg-dark">Paid Amount</th>
                            <th class="bg-dark">Balance</th>
                            <th class="bg-dark">Remarks/Narration</th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                            <td></td>
                            <td></td>
                            <td class="bg-light"></td>
                            <td class="">Opening Balance:</td>
                            <td class="bg-light"><?php echo e($opening_balance); ?></td>
                            <td class=""></td>
                        </tr>
                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($account->created_at); ?></td>
                                <td><?php echo e($account->actions); ?></td>
                                <td class="bg-light"><?php echo e($account->received_amount); ?></td>
                                <td class=""><?php echo e($account->paid_amount); ?></td>
                                <td class="bg-light"><?php echo e($account->cur_balance); ?></td>
                                <td class=""><?php echo e($account->comments); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                            <td class="bg-secondary" class="bg-light"><?php echo e($accounts->sum('received_amount')); ?></td>
                            <td class="bg-secondary"><?php echo e($accounts->sum('paid_amount')); ?></td>
                            <td class="bg-secondary">
                                <?php echo e($accounts->sum('received_amount') + $opening_balance - $accounts->sum('paid_amount')); ?>

                            </td>
                            <td class="bg-secondary"></td>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/fenionline/radius-circle/resources/views/user/accountHistory.blade.php ENDPATH**/ ?>