<section class="detail-area bg-white shadow-sm p-3 mb-5 rounded">
    <div class="row" style="row-gap: 10px;">
        @if (globalPermission('reseller-client-billing'))
            @can('reseller-billing-info')
                @php
                    $currentMonth = today()->format('F');
                    $currentYear = today()->format('Y');
                @endphp

                <x-dashboardBox link="{{ route('resellerBillGenerateReport') }}" icon="calendar-check"
                    title="{{ $currentMonth }} Bill {{ $currentYear }}"
                    value="{{ round($otherResellerBillingInfo['total_bill_this_month']) }}"
                    bgcolor="bgGray" iconColor="colorGray" />

                <x-dashboardBox link="{{ route('reseller-customer-payment-report') }}" icon="calendar-check"
                    title="{{ $currentMonth }} COL {{ $currentYear }}"
                    value="{{ round($otherResellerBillingInfo['total_bill_paid_this_month']) }}"
                    bgcolor="bgYellow" iconColor="bgYellow" />

                <x-dashboardBox link="{{ route('reseller-customer-payment-report') }}" icon="calendar-check"
                    title="Discount {{ $currentMonth }} {{ $currentYear }}"
                    value="{{ round($otherResellerBillingInfo['total_discount_this_month']) }}"
                    bgcolor="discount-month" iconColor="bgWhite" />

                <x-dashboardBox link="{{ route('resellerBillGenerateReport') }}" icon="calendar-check"
                    title="{{ $currentMonth }} Due {{ $currentYear }}"
                    value="{{ round($otherResellerBillingInfo['total_due_amount_this_month']) }}"
                    bgcolor="bgGreen" iconColor="colorGreen" />
               
                <x-dashboardBox link="{{ route('resellerBillGenerateReport') }}" icon="funnel-dollar"
                    title="Total Due"
                    value="{{ round($otherResellerBillingInfo['total_due_amount'] ?? 0) }}"
                    bgcolor="bgRed" iconColor="colorPurple" />

                <x-dashboardBox link="{{ route('resellerBillGenerateReport') }}" icon="calendar-day"
                    title="Previous Due"
                    value="{{ round($otherResellerBillingInfo['previous_due'] ?? 0) }}"
                    bgcolor="prev-col" iconColor="colorGreen" />

                <x-dashboardBox link="{{ route('reseller-customer-payment-report') }}" icon="wallet"
                    title="Today Payment Received"
                    value="{{ round($otherResellerBillingInfo['to_day_bill_collection'] ?? 0) }}"
                    bgcolor="bg-today-col" iconColor="colorRed" />

                <x-dashboardBox link="{{ route('reseller-customer-payment-report') }}" icon="wallet"
                    title="This Month Payment Received"
                    value="{{ round($otherResellerBillingInfo['this_month_bill_collection'] ?? 0) }}"
                    bgcolor="bgGray" iconColor="colorRed" />
            @endcan
        @endif
    </div>
</section>
