<table id="dataTable" class="table table-bordered table-striped table-condensed">
    <thead class="bg-gray-50">
        <tr class="bg-black text-center">
            <th scope="col"> ID</th>
            <th scope="col">Token</th>
            <th scope="col">Code</th>
            <th scope="col">Date</th>
            <th scope="col">Description</th>
            <th scope="col">Username</th>
            <th scope="col">Address</th>
            <th scope="col">Reporter</th>
            <th scope="col">Contact</th>
            <th scope="col">Assigned</th>
            <th scope="col">Creator</th>
            <th scope="col">Creator(Client)</th>
            <th scope="col" style="width: 240px">Remarks</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($list as $r)
            <tr>
                <td>{{ $r->id }}</td>
                <td>{{ $r->token }}</td>
                <td>{{ $r->Code->tokenCode ?? '' }}</td>
                <td>{{ $r->created_at }}</td>
                <td>{{ $r->description }}</td>
                <td>{{ $r->clients->userid ?? '' }}</td>
                <td style="width:350px;">
                    <p style="font-size:14px;">
                        @if (!empty($r->clients->clientsinfo->flat_no))
                            Flat No: {{ $r->clients->clientsinfo->flat_no ?? '' }},
                        @endif
                        @if (!empty($r->clients->clientsinfo->building_name))
                            Building Name: {{ $r->clients->clientsinfo->building_name ?? '' }},<br>
                        @endif
                        @if (!empty($r->clients->clientsinfo->road_no))
                            Road No: {{ $r->clients->clientsinfo->road_no ?? '' }},<br>
                        @endif
                        @if (!empty($r->clients->clientsinfo->block_sector))
                            Block/Sector: {{ $r->clients->clientsinfo->block_sector ?? '' }},
                        @endif
                        @if (!empty($r->clients->clientsinfo->area))
                            Area : {{ $r->clients->clientsinfo->area ?? '' }}, <br>
                        @endif
                        @if (!empty($r->clients->clientsinfo->box))
                            Box : {{ $r->clients->clientsinfo->box ?? '' }}
                        @endif
                    </p>
                </td>
                <td>{{ $r->reportedBy }}</td>
                <td>{{ $r->reporterContact }}</td>
                <td>{{ $r->employees->name ?? '' }}</td>
                <td>{{ $r->creator->name ?? '' }}</td>
                <td>{{ $r->createByClient }}</td>
                <td>
                    <form action="{{ route('closeTokenStore', $r->id) }}" method="POST" name="editForm">
                        @csrf
                        <input type="hidden" name="closeUserId" value="{{ Auth::user()->id }}">
                        <select class="form-control bSelect" name="status">
                            <option value="Inactive" selected>Closed</option>
                        </select>
                        <input name="remarks" required placeholder="Remarks" type="text"
                            class="form-control" value="{{ $r->remarks }}">
                        <button type="submit" class="btn btn-danger float-right">
                            Close
                        </button>
                    </form>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
