<?php

namespace App\Models;

use App\Models\User;
use App\Models\Balance;
use App\Models\Reseller;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ResellerRechargeReport extends Model
{
    use HasFactory;

    protected $guarded = [];


    public function reseller()
    {
        return $this->hasOne(Reseller::class,'id','reseller_id');
    }

    public function user(){
        return $this->hasOne(User::class,'id','user_id');
    }

    public function balance()
    {
        return $this->hasMany(Balance::class,'type_id','reseller_id')->whereType('reseller');
       
    }

}
