<!DOCTYPE HTML>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title></title>
    <style type="text/css">
        td {
            padding-top: 0 !important;
            padding-bottom: 0 !important;
            line-height: 1;
        }

        td p {
            line-height: initial !important;
            margin: 0;
        }

        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body onload="window.print()" onfocus="window.close()">
    <style>
        @media  print {
            thead th {
                font-size: 15px !important;
                border: 1px solid #ddd;
            }

            #pop,
            button {
                visibility: hidden;
            }

            table,
            tr,
            thead th,
            td {
                font-size: 12px !important;
                padding: 2px !important;
                border: 1px solid #010a02;
                border-collapse: collapse;
            }
        }

        .container {
            width: 940px;
            margin: 0 auto;
            padding: 10px;
        }

        .table {

            border-collapse: collapse;
            width: 100%;
            border: 1px solid #4CAF50;
        }

        h2 {
            text-align: center;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #bbb;
            padding: 10px;
            text-align: left;
        }

        tr:hover {
            background-color: #e5e5e5
        }
    </style>

    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">
            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                        <div class="flex justify-between noprint">
                            <div class="p-2 mb-5">
                                <button type="button" onclick="window.print()">Print
                                    <i class="fa fa-print"></i>
                                </button>
                            </div>
                        </div>
                        <table class="table table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="">ID</th>
                                    <th>User name</th>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-client-password')): ?>
                                        <th>Password</th>
                                    <?php endif; ?>
                                    <th>Status</th>
                                    <th>Bill Cycle</th>
                                    <th>Package</th>
                                    <?php if($price == 'yes'): ?>
                                        <th>Package price</th>
                                    <?php endif; ?>

                                    <th>Due</th>
                                    <th>POP</th>
                                    <th>Name</th>
                                    <th>Area</th>
                                    <th>Block</th>
                                    <th>Road Name</th>
                                    <th>Road No</th>
                                    <th>Building Name</th>
                                    <th>Building No</th>
                                    <th>Flat</th>
                                    <th>Box</th>
                                    <th>OLT/PON</th>
                                    <th>Latitude</th>
                                    <th>Longitude</th>
                                    <th>Contact No</th>
                                    <?php if(checkSettings('blank-column') == 'enable'): ?>
                                        <th style="width: 100px"></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    if(auth()->user()->id == 1){
                                        $password = $r->password;
                                    } else {
                                        $password = '********';
                                    }
                                ?>
                                    <tr>
                                        <td> <?php echo e($r->id); ?>

                                        </td>
                                        <td>
                                            <b><?php echo e($r->userid); ?></b>
                                        </td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view-client-password')): ?>
                                            <td>
                                                <?php echo e($password); ?>

                                            </td>
                                        <?php endif; ?>

                                        <?php if($r->clients_status == 'expired'): ?>
                                            <td class="deactive bg-danger">
                                                Expired
                                            <?php elseif($r->clients_status == 'deactive'): ?>
                                            <td class="deactive bg-danger">
                                                Deactive
                                            <?php elseif($r->clients_status == 'disable'): ?>
                                            <td class="bg-warning">
                                                Disable
                                            <?php elseif($r->clients_status == 'active'): ?>
                                            <td class="bg-success">
                                                Active
                                            <?php elseif($r->client_approval == 'pending'): ?>
                                            <td>
                                                Pending
                                        <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($r->billing_cycle); ?>

                                        </td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-sub-package')): ?>
                                                <span
                                                    class="badge badge-info"><b><?php echo e($r->subpack->name ?? ''); ?></b></span><br>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-mother-package')): ?>
                                                <span class="badge badge-info">
                                                    <b><?php echo e($r->packages->package_name ?? ''); ?></b></span>
                                            <?php endif; ?>
                                            <?php if(!empty($r->subpack->name)): ?>
                                            <?php else: ?>
                                            <?php endif; ?>
                                        </td>
                                        <?php if($price == 'yes'): ?>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-sub-package-rate')): ?>
                                                    <span class="badge badge-info"><?php echo e($r->subpack->rate ?? 0); ?></span>
                                                <?php endif; ?>
                                                ,
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-motherpackage-rate')): ?>
                                                    <span
                                                        class="badge badge-info"><?php echo e($r->packages->package_rate ?? 0); ?></span>
                                                <?php endif; ?>
                                                ,
                                                <?php if(!empty($r->sub_package_rate)): ?>
                                                <?php else: ?>
                                                <?php endif; ?>


                                            </td>
                                        <?php endif; ?>

                                        <td>
                                            <?php if($r->pop->bill_generate == 'yes'): ?>
                                                <?php echo e($r->customerAccount->dueAmount ?? 0); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($r->pop->popname); ?>

                                        </td>
                                        <td>
                                            <?php echo e($r->clientsinfo->clients_name ?? ''); ?>

                                        </td>
                                        <td><?php echo e($r->clientsinfo->area ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->block_sector ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->road_name ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->road_no ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->building_name ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->building_no ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->flat_no ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->box ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->olt_pon ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->client_latitude ?? ''); ?></td>
                                        <td><?php echo e($r->clientsinfo->client_longitude ?? ''); ?></td>

                                        
                                        <td>
                                            <b><?php echo e($r->clientsinfo->contact_no ?? ''); ?></b>
                                        </td>
                                        <?php if(checkSettings('blank-column') == 'enable'): ?>
                                            <td style="width: 100px"></td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td colspan="15">
                                        <p class="text-center">
                                            Total Customer: <?php echo e($list->count()); ?> |
                                            Total Active: <?php echo e($list->where('clients_status', 'active')->count()); ?> |
                                            Total Expired: <?php echo e($list->where('clients_status', 'expired')->count()); ?> |
                                            Total Disable: <?php echo e($list->where('clients_status', 'disable')->count()); ?>|
                                            Total Deactive: <?php echo e($list->where('clients_status', 'deactive')->count()); ?>

                                        </p>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        window.onload = function() {
            window.print();
        }

        window.onfocus = function() {
            window.close();
        }
    </script>
</body>

</html>
<?php /**PATH /var/www/html/fenionline/radius-circle/resources/views/clients/search/print.blade.php ENDPATH**/ ?>