@extends('layout.app')


@section('content')

    <form action="{{ route('tokenStore') }}" method="POST">
        @csrf
        <div class="card">
            <div class="card-body">
                <input type="hidden" name="createdBy" value="{{ Auth::user()->id }}">
                <div class="row">
                    <div class="form-group col-md-3">
                        <label for="shortname">CID</label>
                        <input type="" name="clientId" id="clientId" value="{{ $client->id }}"
                            class="form-control" placeholder="" autocomplete="off" readonly>
                        @error('clientId')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3">
                        <label for="shortname">Username</label>
                        <input type="" value="{{ $client->userid }}" class="form-control" placeholder=""
                            autocomplete="off" readonly>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="shortname">Token Category*</label>
                        <select name="tokenCategory" id="tokenCategory" class="form-control bSelect" required>
                            <option value="">Select Token Category</option>
                            {{-- @if (auth()->user()->hasRole('Admin')) --}}
                            @foreach ($tokenCategory as $item)
                                <option value="{{ $item->id }}">{{ $item->tokenCategory }}</option>
                            @endforeach
                            {{-- @else
                            <option value="{{ $auth_reseller->id }}">{{ $auth_reseller->name }}</option>
                        @endif --}}
                        </select>
                        @error('tokenCategory')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3">
                        <label for="shortname">Token Code*</label>
                        <select name="tokenCode" id="tokenCode" class="form-control bSelect select2" required>
                            <option value=""> Select One Code</option>
                        </select>
                        @error('tokenCode')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label for="shortname">Description*</label>
                        <textarea type="text" name="description" id="name" value="" rows="2" class="form-control"
                            placeholder="Description" autocomplete="off" required></textarea>
                        @error('description')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3">
                        <label for="shortname">Reported By*</label>
                        <input type="text" name="reportedBy" id="name" value="" class="form-control"
                            placeholder="Reported By" autocomplete="off" required>
                        @error('reportedBy')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3">
                        <label for="shortname">Reporter Contact No*</label>
                        <input type="text" name="reporterContact" id="name" value="" class="form-control"
                            minlength="11" maxlength="11" placeholder="Reporter Contact No" autocomplete="off" required>
                        @error('reporterContact')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}</div>
                        @enderror
                    </div>
                    @if (checkSettings('token_source') == 'enable')
                        <div class="form-group col-md-3">
                            <label>Token Source*</label>
                            <select name="token_source" id="" class="form-control select2" required>
                                <option value="">Select One</option>
                                @forelse ($tokenSource as $item)
                                    <option value="{{ $item->name }}">{{ $item->name }}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    @endif
                    @can('assign-token')
                        <div class="form-group col-md-3">
                            <label for="shortname">Assign To</label>
                            <select name="employee" id="employee" class="form-control bSelect select2">
                                <option value="">Select Employee</option>
                                @foreach ($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endcan
                    <div class="form-group col-md-3">
                        <label for="shortname">Token Type*</label>
                        <select name="token_type" id="token_type" class="form-control bSelect select2" required>
                            <option value="">Select Token Type</option>
                            <option value="Logical">Logical</option>
                            <option value="Physical">Physical</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Save
                    </button>
                </div>

            </div>
        </div>
    </form>
    <style>
        div#processing {
            display: none;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media print {
            a {
                text-decoration: none !important;
                color: #222 !important;
            }

            th {
                font-size: 10px !important;
                padding: 2px !important;
                text-align: center;
            }

            tr {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            td {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            table {
                width: 100%;
            }

            .shadow {
                box-shadow: none;
            }

            tr th:last-child {
                display: none !important;
            }

            tr td:last-child {
                display: none !important;
            }

        }
    </style>


@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#tokenCode').html('<option value="">Select One</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('onlineCustomerSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').remove();

                    }
                });
            });


            $('#tokenCategory').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getTokenCodeList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#tokenCode').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
