<?php

namespace App\Models;

use App\Models\Reseller;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Pop extends Model
{
    use HasFactory;

    protected $fillable = [
        'popname',
        'reseller_id',
        'pop_location',
        'pop_contact',
        'nas_id',
        'longitude',
        'latitude',
        'server_authentication',
        'billable',
        'subreseller',
        'bill_generate',
        'package_change_pricing',
        'payment_charges',
        'created_by',
        'active_inactive'
    ];

    public function reseller()
    {
        return $this->belongsTo(Reseller::class, 'reseller_id');
    }
    public function resellers()
    {
        return $this->belongsTo(Reseller::class, 'reseller_id', 'id');
    }


    public function nas()
    {
        return $this->belongsTo(Nas::class, 'nas_id');
    }

    public function balance()
    {
        return $this->hasMany(Balance::class, 'type_id', 'id')->whereType('pop');
    }


    public function clients()
    {
        return $this->hasMany(Client::class, 'pop_id', 'id');
    }





    static function popForReseller($user)
    {
        $reseller_ids = DB::table('reseller_user')->where('user_id', $user->id)->pluck('reseller_id')->toArray();



        $pops = Pop::whereIn('reseller_id', $reseller_ids);

        return $pops;
    }

    static function poplist()
    {
        $id = auth()->id();


        $pop = Pop::with('nas', 'reseller', 'balance');

        if (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

            $reseller_ids = DB::table('reseller_user')->where('user_id', $id)->pluck('reseller_id')->toArray();

            $pop = $pop->whereIn('reseller_id', $reseller_ids);
        } elseif (auth()->user()->hasRole('Sub Reseller')) {

            $pop_ids = DB::table('pop_user')->where('user_id', $id)->pluck('pop_id')->toArray();

            $pop = $pop->whereIn('id', $pop_ids);
        }

        return $pop->get();
    }


    static function list()
    {

        // $pop = cache()->remember('pop_' . auth()->user()->id, 60, function () {

            $id = auth()->id();
            if (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

                $reseller_ids = DB::table('reseller_user')->where('user_id', $id)->pluck('reseller_id')->toArray();
                $pop = Pop::with('reseller', 'nas', 'balance')->whereIn('reseller_id', $reseller_ids);

            } elseif (auth()->user()->hasRole('Sub Reseller')) {

                $pop_ids = DB::table('pop_user')->where('user_id', $id)->pluck('pop_id')->toArray();
                // dd($pop_ids);
                $pop = Pop::with('nas', 'balance')->whereIn('id', $pop_ids);

            } else {

                $pop = Pop::with('reseller', 'nas', 'balance');
            }

            if(checkSettings('active_inactive_pop') == 'enable'){
                $pop = $pop->where('active_inactive', 'active');
            }

            return $pop->orderBy('popname', 'asc')->get();
        // });

        // return $pop;
    }

    static function conditionalList()
    {
        $id = auth()->id();


        if (auth()->user()->hasRole(['Reseller Admin', 'Reseller'])) {

            $reseller_ids = DB::table('reseller_user')->where('user_id', $id)->pluck('reseller_id')->toArray();
            // $resellers = Reseller::with('balance')->whereIn('id',$reseller_ids)->get();
            $pop = Pop::with('reseller', 'nas', 'balance')->whereIn('reseller_id', $reseller_ids);

            // dd($pop);

        } elseif (auth()->user()->hasRole('Sub Reseller')) {

            $pop_ids = DB::table('pop_user')->where('user_id', $id)->pluck('pop_id')->toArray();
            // dd($pop_ids);
            $pop = Pop::with('nas', 'balance')->whereIn('id', $pop_ids);
        } else {

            $pop = Pop::with('reseller', 'nas', 'balance');
        }

        if(checkSettings('active_inactive_pop') == 'enable'){
            $pop = $pop->where('active_inactive', 'active');
        }

        return $pop->orderBy('popname', 'asc')->get();
    }

    public function popEditLog()
    {
        return $this->hasMany(PopEditLog::class, 'pop_id', 'id');
    }

}
