<?php
    use Illuminate\Support\Facades\Redis;
?>
<?php $attributes = $attributes->exceptProps(['isStatic', 'userid', 'ip_address', 'online']); ?>
<?php foreach (array_filter((['isStatic', 'userid', 'ip_address', 'online']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php if(!$isStatic): ?>
    <?php
        $userid = $userid ?? '';
        $useRedis = globalPermission('clientManageThroughNodeJs');

        if ($useRedis) {
            $userActiveInfo = json_decode(Redis::get('active:' . $userid), true);
            $userSecretInfo = json_decode(Redis::get('secret:' . $userid), true);
            $isOnline = $userActiveInfo !== null;
            $currentAddress = $userActiveInfo['address'] ?? '';
            $lastLoggedOut = $userSecretInfo['last-logged-out'] ?? null;
        } else {
            $isOnline = array_key_exists($userid, $online['onlineUsers']);
            $currentAddress = $online['onlineUsers'][$userid]['address'] ?? '';
            $lastLoggedOut = $online['allUsers'][$userid]['last-logged-out'] ?? null;
        }
    ?>

    <?php if($isOnline): ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('router-remote-access')): ?>
            <a href="http://<?php echo e($currentAddress); ?>:<?php echo e(siteinfo()->remote_router_port ?? ''); ?>"
                class="" target="_blank">
                <i class="fa fa-sign-out bg-info text-light p-1 rounded-circle" aria-hidden="true"
                    style="font-size: 0.75rem;"></i>
            </a>
        <?php endif; ?>
        <span class="btn-success btn-xs">
            <?php if(globalPermission('online-offline-using-api')): ?>
                Online
            <?php else: ?>
                <?php echo e($currentAddress); ?>

            <?php endif; ?>
        </span>
    <?php else: ?>
        <?php if($lastLoggedOut): ?>
            <?php if(preg_match('/\b\d{4}\b/', $lastLoggedOut, $matches) == 1): ?>
                <?php if($matches[0] != '1970'): ?>
                    <span class="btn btn-danger btn-xs">
                        <?php if(globalPermission('online-offline-using-api')): ?>
                            Offline
                        <?php else: ?>
                            <?php echo e($useRedis ? $lastLoggedOut : parseDate($lastLoggedOut)); ?>

                        <?php endif; ?>
                    </span>
                <?php else: ?>
                    <span class="btn-warning btn-xs p-1 text-light">
                        Never Connected
                    </span>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>
<?php else: ?>
    <?php if(isset($ip_address)): ?> {
        <?php if(array_key_exists($ip_address, $online['ipArpListsGlobal'])): ?>
            <span class="mt-1 btn <?php if($online['ipArpListsGlobal'][$ip_address]['disabled'] == 'false'): ?> btn-success <?php else: ?> btn-danger <?php endif; ?> btn-xs">
                <?php echo e($online['ipArpListsGlobal'][$ip_address]['disabled'] == 'false' ? 'Online' : 'ARP-Disabled'); ?>

            </span>
        <?php endif; ?>
    <?php else: ?>
        <span class="btn btn-danger btn-xs">Offline</span>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /var/www/html/fenionline/radius-circle/resources/views/components/client-connection-status.blade.php ENDPATH**/ ?>