import React from "react";
import Select from "react-select";
import styles from "./BoxUserSearch.module.css";
import { useSelector } from "react-redux";
import useMap from "../../../hooks/useMap";

export const BoxUserSearch = () => {
    const { map } = useMap();
    const { clusters } = useSelector((state) => state.clusterReducer);

    const onChangeHandler = (cluster) => {
        if (!cluster) return;

        const coordinates = JSON.parse(cluster.value);
        map.panTo(coordinates);
        map.setZoom(25);
    };

    return (
        <div className={styles.BoxUserSearch}>
            <Select
                onChange={onChangeHandler}
                options={clusters.map((cluster) => ({
                    value: cluster.coordinates,
                    label: cluster.name,
                }))}
                placeholder="Search Boxes..."
                isSearchable
                isClearable
            />
        </div>
    );
};
