@extends('layout.app')
@section('content')
    <div class="card">

        <div class="card-header d-flex justify-content-between noprint">
            <button class="btn btn-info btn-sm" onclick="window.print()">Print</button>
            <div>

                <form class="form-inline">
                    @csrf
                    <div class="form-group">
                        <label for="month" class="pr-2">Month</label>
                        <select name="month" id="month" class="form-control" required>
                            <option value="">Select Month</option>
                            <option value="{{ today()->format('F') }}">{{ today()->format('F') }}</option>
                            <option value="{{ today()->addMonth()->format('m') }}">{{ today()->addMonth()->format('F') }}
                            </option>

                        </select>
                    </div>
                </form>
            </div>
            </select>
            {{ $list->appends(['type' => request()->type, 'search' => request()->search])->links() }}

        </div>
        <div class="card-body">

            @foreach ($list as $r)
                <div class="singlePage">
                    <table>
                        <tr>
                            <td
                                style="width: 300px; padding-right: 30px; border-right: 1px dashed #000; vertical-align: top;">
                                <img src="{{ asset('storage/company') }}/{{ $company_info->img_url }}" alt="no"
                                    height="50px" width="50px">
                                <h3 style="font-weight: bold">{{ $company_info->name ?? '' }}</h3>
                                For Office Use
                                <hr>
                                Invoce No: {{ date('Y') }}{{ $r->invoice_id ?? '' }}<br>
                                @if ($r->customer_code != null)
                                    Code: {{ $r->customer_code ?? '' }}<br>
                                @else
                                    CID: {{ $r->id }}<br>
                                @endif
                                Name: {{ $r->clients_name ?? '' }}<br>
                                Username: {{ $r->userid }}<br>
                                Mobile: {{ $r->contact_no ?? '' }}<br>
                                Monthly Bill: {{ $r->billamount - $r->paidAmount ?? '' }}<br>
                                Total Due: {{ number_format($r->dueAmount ?? '', 2) }}<br><br> {{-- {{ $r->due_amount ?? '' }} --}}

                                Signature:

                            </td>
                            <td style="padding-left: 25px; vertical-align: top;">
                                <table>
                                    <tr>
                                        <td>
                                            <img src="{{ asset('storage/company') }}/{{ $company_info->img_url }}"
                                                alt="no" height="50px" width="50px">
                                        </td>
                                        <td style="text-align: center;" colspan="2">
                                            <h3 style=" font-weight:bold;">{{ $company_info->name ?? '' }}</h3>
                                        </td>
                                        <td style="text-align: right" colspan="2">
                                            {!! $company_info->address !!}<br>
                                            {{ $company_info->mobile ?? '' }}
                                        </td>

                                    </tr>
                                    <tr>

                                        <td colspan="3">
                                            <b>To</b><br>
                                            @if ($r->customer_code != null)
                                                <b>Code:</b> {{ $r->customer_code ?? '' }}<br>
                                            @else
                                                <b>CID:</b> {{ $r->id }}<br>
                                            @endif
                                            <b>Name:</b> {{ $r->clients_name ?? '' }}<br>
                                            <b>Username:</b> {{ $r->userid }}<br>
                                            <b>Mobile:</b> {{ $r->contact_no ?? '' }}<br>
                                            <b>Address:</b>
                                            @if ($r->building_name)
                                                <b>B Name:</b> {{ $r->building_name ?? '' }},
                                            @endif
                                            @if ($r->owner_name)
                                                <b>H O:</b> {{ $r->owner_name ?? '' }},
                                            @endif
                                            @if ($r->flat_no)
                                                <b>F No:</b> {{ $r->flat_no ?? '' }},
                                            @endif
                                            @if ($r->road_name)
                                                <b>R Name:</b> {{ $r->road_name ?? '' }},
                                            @endif
                                            @if ($r->road_no)
                                                <b>R No:</b> {{ $r->road_no ?? '' }},
                                            @endif
                                            @if ($r->block_sector)
                                                <b>Block/Sector:</b> {{ $r->block_sector ?? '' }},
                                            @endif
                                            @if ($r->area)
                                                <b>Area:</b> {{ $r->area ?? '' }},
                                            @endif
                                            @if ($r->box)
                                                <b>Box:</b> {{ $r->box ?? '' }}
                                            @endif
                                        </td>
                                        <td style="text-align: right">
                                            Customer Copy
                                        </td>

                                    </tr>
                                    <tr style="background-color: #b8b8b8">
                                        <td style="border: 1px solid #000; padding-left:5px">IP: </td>
                                        <td style="border: 1px solid #000; padding-left:5px">Total Due:
                                            {{ number_format($r->dueAmount ?? '', 2) }}</td>
                                        <td style="border: 1px solid #000; padding-left:5px"> Invoice No:
                                            {{ date('Y') }}{{ $r->invoice_id ?? '' }}</td>
                                        <td style="border: 1px solid #000; padding-left:5px">Expire Date:
                                            {{ date('d-M-Y', strtotime($r->expire_date ?? '')) }}</td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            SL.
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            Description
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            Month
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">Bill Amount</td>
                                    </tr>
                                    @php
                                        $current_bill = ($r->billamount - $r->paidAmount) ?? 0;
                                        $previous_due = ($r->dueAmount - $current_bill) ?? 0;
                                    @endphp
                                    <tr>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            1
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            Monthly Bill
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            {{ date('F', strtotime($r->bill_create_date ?? '')) }}
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px; text-align:right">
                                            {{-- {{ number_format($r->billamount - $r->paidAmount ?? '', 2) }} --}}
                                            {{ number_format($current_bill, 2) }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            2
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            Prevoius Due / Others
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px">
                                            --
                                        </td>
                                        <td style="border: 1px solid #000; padding-left:5px; text-align:right">
                                            {{-- @if ($r->paidAmount == $r->billamount)
                                                {{ number_format(abs($r->dueAmount), 2) }}
                                            @else
                                                {{ number_format(abs($r->dueAmount - $r->billamount), 2) }}
                                            @endif --}}

                                            {{-- @if ($r->dueAmount - $r->package_rate > 0)
                                                {{ number_format(abs($r->dueAmount - $r->package_rate), 2) }}
                                            @else
                                                {{ number_format(0, 2) }}
                                            @endif --}}
                                            {{ number_format($previous_due, 2) }}
                                        </td>
                                    </tr>
                                    <tr>

                                        <td colspan="3"
                                            style="border: 1px solid #000; text-align:center; font-weight:bold; font-size:20px">
                                            Total Due
                                        </td>
                                        <td
                                            style="border: 1px solid #000; font-weight:bold; padding-left:5px; text-align:right">
                                            {{ number_format($r->dueAmount ?? '', 2) }}
                                        </td>
                                    </tr>
                                </table>
                                <br>
                                @if ($company_info->signature == null)
                                    Signature:
                                @else
                                    <img src="{{ asset('storage/company') }}/{{ $company_info->signature }}"
                                        alt="no" height="30px" width="60px">
                                @endif
                                <br>
                            </td>
                        </tr>
                    </table>
                </div>
                <br>
                <hr style="border-top:1px dashed #000;padding-top:20px;">
            @endforeach

        </div>
    </div>
@endsection

@section('ajax')
    @if (checkSettings('singlePageBillInvoice') == 'enable')
        <style>
            @media print {
                .card-header {
                    display: none;
                }

                .noprint {
                    display: none !important;
                }

                td {
                    padding: 2px;
                }

                td {
                    font-size: 16px !important;
                }

                .cname {
                    font-size: 50px;
                }

                /* table {
                            page-break-after: always;
                        } */
                .singlePage {
                    page-break-after: always;
                }

                hr {
                    display: none;
                }
            }
        </style>
    @else
        <style>
            @media print {
                .card-header {
                    display: none;
                }

                .noprint {
                    display: none !important;
                }

                td {
                    padding: 2px;
                }

                td {
                    font-size: 16px !important;
                }

                .cname {
                    font-size: 50px;
                }
            }
        </style>
    @endif

    <style>
        table {
            width: 100%;
            padding: 2px;
        }

        td {
            padding: 2px;
        }
    </style>

    <script type="text/javascript">
        $(document).ready(function() {

            console.log('hi');
            $('#month').on('change', function() {
                var selectedValue = $(this).val();

                // Make the AJAX request
                $.ajax({
                    url: '{{ route('setMonthForInvoicePrint') }}',
                    method: 'POST', // or 'GET', depending on your server setup
                    data: {
                        selectedValue: selectedValue
                    },
                    success: function(response) {
                        location.reload();
                    }
                });
            });
        });
    </script>
@endsection
