import { createSlice } from '@reduxjs/toolkit';

const initialState = {
    tjBoxes: [],
};

const reducers = {
    setTjBoxes(state, action) {
        state.tjBoxes = action.payload;
        return state;
    },
    addTjBox(state, action) {
        state.tjBoxes.push(action.payload);
        return state;
    },

    removeTjBox(state, action) {
        const index = state.tjBoxes.findIndex(
            (tjBox) => tjBox.id === action.payload
        );
        if (index !== -1) {
            state.tjBoxes.splice(index, 1);
        }
        return state;
    },
};

const tjBoxReducer = createSlice({
    name: 'tjBoxReducer',
    initialState,
    reducers,
});

export const { setTjBoxes, addTjBox, removeTjBox } = tjBoxReducer.actions;

export default tjBoxReducer.reducer;
