<?php

namespace App\Models\map;

use App\Models\Client;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Port extends Model
{
    use HasFactory;

    protected $table = "port_map";
    protected $fillable = [
        "label",
        "port_number",
        "type",
        "port_type",
        "device_id",
        "port_stream",
        "fiber_id",
        "cable_id",
        "connected_component_id",
        "connected_component_type",
        "pon_count",
        "pon_limit",
    ];

    protected $morphClass = 'port';



    public function device()
    {
        return $this->belongsTo(Device::class, "device_id");
    }

    public function fiber()
    {
        return $this->belongsTo(Fiber::class, "fiber_id");
    }

    public function cable()
    {
        return $this->belongsTo(Cable::class, "cable_id");
    }

    public function connectedComponent()
    {
        return $this->morphTo(null, 'connected_component_type', 'connected_component_id');
    }

    // this is useless for now
    public function splitter()
    {
        return $this->belongsTo(Splitter::class, "splitter_id");
    }

    public function client()
    {
        return $this->hasOne(Client::class, "id");
    }
}
