@extends('layout.app')

@section('content')
    @include('clients.reseller_pop_search')


    <div class="mt-2 card">
        <div class="card-body">
            <div id="customer_list_body">
                <div id="processing">
                    <div>Processing.....</div>
                </div>
                <p class="listCounter">Total: {{ $list->total() }}</p>
                <div class="table-responsive">
                    @include('clients.customer_search')
                </div>
                {{ $list->links() }}

            </div>
        </div>
        <div class="card-footer">
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('#processing').show();
                $('nav .pagination').hide();
                $('.listCounter').hide();

                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('activeCustomerSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').hide();

                    }
                });
            });

        });
    </script>

@endsection
