<?php

namespace App\Http\Controllers\Accounting;

use Carbon\Carbon;
use App\Models\User;
use App\Models\FundTransfer;
use Illuminate\Http\Request;
use App\Models\UserAccounting;
use App\Http\Controllers\Controller;

class CashInHandController extends Controller
{
    public function cashInHand(request $request, $type)
    {


        if($request->from_date!=null &&  $request->to_date!=null){
            $start = Carbon::parse($request->from_date);
            $end   = Carbon::parse($request->to_date);
        }else{
            $start = Carbon::now()->startOfMonth();
            $end = today()->addDay();
        }



        if ($type == 'all') {

            $users = User::where('user_accounting_status','yes')->get();



            $accounts = UserAccounting::selectRaw('sum(received_amount) as ramount, sum(paid_amount) as pamount,user_id')
                ->whereBetween('created_at', [$start, $end])
                ->groupBy('user_id')->get();


            $opening_balance = UserAccounting::selectRaw('(sum(received_amount) - sum(paid_amount)) as opening_amount,user_id')
                ->whereRaw("created_at < '$start'")
                ->groupBy('user_id')->get();


            $cash['cash_received'] = FundTransfer::selectRaw(' sum(amount) as cash ')
                ->whereRaw(' fund_received_by=0 and amount > 0')
                ->whereBetween('created_at', [$start, $end])->first()->cash;

            $cash['cash_paid'] = FundTransfer::selectRaw(' sum(amount) as cash ')
                ->whereRaw(' (fund_send_by=0 && amount < 0 )')
                ->whereBetween('created_at', [$start, $end])->first()->cash;

            $cash['cash_opening'] = FundTransfer::selectRaw(' sum(amount) as cash_balance ')
                ->whereRaw(' (fund_send_by=0 or fund_received_by=0 ) ')
                ->whereRaw("created_at < '$start'")->first()->cash_balance;

            $data = array();

            foreach($users as $user){
                if($user->email != "rokibulhasan.356@gmail.com" && $user->email != "soiket@outlook.com" && $user->email != "support@yetfix.com" && $user->email != "admin@billingfix.xyz"){

                    $data[$user->id]['user_id'] = $user->id;
                    $data[$user->id]['name']    = $user->name;
                    $data[$user->id]['email']    = $user->email;

                    foreach ($opening_balance as $op) {

                        if ($user->id == $op->user_id) {
                            $data[$user->id]['op_balance'] = $op->opening_amount;
                        }
                    }

                    foreach ($accounts as $ac) {
                        if($ac->user_id == $user->id){

                            $data[$user->id]['ramount'] = $ac->ramount;
                            $data[$user->id]['pamount'] = $ac->pamount;

                        }
                    }
                }



            }

            // dd($cash);

            // foreach ($accounts as $ac) {
            //     $data[$ac->user_id]['ramount'] = $ac->ramount;
            //     $data[$ac->user_id]['pamount'] = $ac->pamount;
            //     $data[$ac->user_id]['user_id'] = $ac->user_id;
            //     $data[$ac->user_id]['name'] = $users->where('id', $ac->user_id)->first()->name;

            // }
        } elseif ($type == 'cash') {
            $cash['cash_opening'] = FundTransfer::selectRaw(' sum(amount) as cash_balance ')
                                                ->whereRaw(' (fund_send_by=0 or fund_received_by=0 ) ')
                                                ->whereRaw("created_at < '$start'")->first()->cash_balance??0;

             $data = FundTransfer::whereRaw(' (fund_send_by=0 or fund_received_by=0 ) ')
                                    ->whereBetween('created_at', [$start, $end])->get();
        }


        // $data = (object) $data;

        // dd($data);


        return view('report.cash_in_hand', [
            'page_title' => 'User Cash In Hand',
            'type'   => $type,
            'data'   => $data,
            'cash'   => $cash,
            'start' => $start,
            'end' => $end
        ]);
    }

    public function cash_in_hand_api()
    {

        $start = Carbon::now()->startOfMonth();
        $end = today()->addDay();

        // dd($start);



        $users = User::all();

        $accounts = UserAccounting::selectRaw('sum(received_amount) as ramount, sum(paid_amount) as pamount,user_id')
            ->whereBetween('created_at', [$start, $end])
            ->groupBy('user_id')->get();


        $opening_balance = UserAccounting::selectRaw('(sum(received_amount) - sum(paid_amount)) as opening_amount,user_id')
            ->whereRaw("created_at < '$start'")
            ->groupBy('user_id')->get();

        $data = array();

        foreach ($accounts as $ac) {
            $data[$ac->user_id]['ramount'] = $ac->ramount;
            $data[$ac->user_id]['pamount'] = $ac->pamount;
            $data[$ac->user_id]['user_id'] = $ac->user_id;
            $data[$ac->user_id]['name'] = $users->where('id', $ac->user_id)->first()->name;
            foreach ($opening_balance as $op) {
                if ($op->user_id == $ac->user_id) {
                    $data[$ac->user_id]['op_balance'] = $op->opening_amount;
                }
            }
        }

        $data = [
            'data' => $data
        ];



        return $data;
    }
}
