<?php

namespace App\Http\Controllers;

use App\Models\StockAdjustmentType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StockAdjustmentTypeController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:supplier_create|supplier_index',['only' => ['create','index']]);
        $this->middleware('permission:supplier_create',['only' => ['create']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = StockAdjustmentType::paginate('100');
        return view('adjustmentType.index',[
            'page_title' => 'Type List',
            'list' => $list,
            'url' => route('adj-type.create'),
            'add_button' => 'true',
            'class' => 'btn btn-primary',
            'value' => 'Add New Type'
             ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('adjustmentType.create',[
            'page_title'=> 'Add New Type'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:stock_adjustment_types',

        ]);
        $stockAdjustmentType = new StockAdjustmentType();
        $stockAdjustmentType->fill($request->all());
        $stockAdjustmentType->creator_user_id = Auth::id();
        $stockAdjustmentType->save();
        $request->session()->flash('success_message', 'Type Added successfull');
        return redirect()->route('adj-type.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\StockAdjustmentType  $stockAdjustmentType
     * @return \Illuminate\Http\Response
     */
    public function show(StockAdjustmentType $stockAdjustmentType)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\StockAdjustmentType  $stockAdjustmentType
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        // dd($stockAdjustmentType);
        return view('adjustmentType.Edit',[
            'list' => StockAdjustmentType::find($id),
            'page_title' => 'Update Unit Information'
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\StockAdjustmentType  $stockAdjustmentType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, StockAdjustmentType $stockAdjustmentType)
    {
        // dd($request->all());
        $stockAdjustmentType=StockAdjustmentType::find($request->id);
        $this->validate($request, [
            'name' => 'required|unique:stock_adjustment_types,name,' . $stockAdjustmentType->id,
        ]);
        $stockAdjustmentType->fill($request->all());
        $stockAdjustmentType->updator_user_id = Auth::id();
        $stockAdjustmentType->save();
        $request->session()->flash('success_message', 'Type Updated Successfull');
        return redirect()->route('adj-type.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\StockAdjustmentType  $stockAdjustmentType
     * @return \Illuminate\Http\Response
     */
    public function destroy(StockAdjustmentType $stockAdjustmentType)
    {
        //
    }
}
