import { Badge, Col } from 'react-bootstrap';
import { BsOpticalAudio, BsFillHddNetworkFill } from 'react-icons/bs';
import { CgEthernet } from 'react-icons/cg';
import { FaNetworkWired } from 'react-icons/fa';
import _ from 'lodash';
import { AiOutlineDownload, AiOutlineUpload } from 'react-icons/ai';
import { getFiberInfo } from '../../../../../../util/colorModule';
import { VscDebugDisconnect } from 'react-icons/vsc';

export function ConnectedComponent({
    connected_component,
    onDisconnectHandler,
    interfaceType,
}) {
    let connectedDevice = null;
    switch (connected_component?.type) {
        case 'splitter_out':
            const coreInfo = getFiberInfo(connected_component.out_number);
            connectedDevice = (
                <span>
                    <span className='ms-1'>
                        {' '}
                        Connected with <FaNetworkWired />{' '}
                    </span>
                    <span>
                        ({_.upperCase(connected_component.splitter.type)})
                    </span>
                    <span className='ms-2 '>
                        {connected_component.id}:-
                        {connected_component.splitter.name} (
                        {connected_component.out_number}:
                        {_.upperCase(coreInfo.color)}{' '}
                        <span
                            style={{
                                backgroundColor: coreInfo.hex,
                                height: '10px',
                                width: '10px',
                                display: 'inline-block',
                            }}
                            className='rounded-circle'
                        />
                        )
                    </span>
                </span>
            );
            break;
        case 'port':
            connectedDevice = (
                <span>
                    {' '}
                    <span className='ms-1'>
                        {' '}
                        Connected with <BsFillHddNetworkFill />{' '}
                    </span>
                    <span>
                        ({_.upperCase(connected_component?.device?.type)})
                    </span>
                    <span className='ms-2 '>
                        {connected_component.id}:-
                        {connected_component.device.name}:
                        {connected_component.port_number}(
                        {connected_component.port_stream === 'incoming' ? (
                            <AiOutlineDownload className='mb-1 mt-1' />
                        ) : (
                            <AiOutlineUpload className='mb-1 mt-1' />
                        )}
                        )
                    </span>
                </span>
            );
            break;
        default:
            connectedDevice = 'Nothing is connected.';
    }
    return (
        <Col lg={6}>
            <div className='p-3 bg-light rounded shadow-sm flex align-items-center'>
                {interfaceType == 'lan' ? (
                    <CgEthernet className='h4 m-0' title={interfaceType} />
                ) : (
                    <BsOpticalAudio className='h4 m-0' title={interfaceType} />
                )}{' '}
                {connectedDevice}
                {connected_component && (
                    <Badge
                        pill
                        className='ms-1'
                        bg='danger'
                        role='button'
                        onClick={() => onDisconnectHandler(interfaceType)}
                    >
                        <VscDebugDisconnect />
                    </Badge>
                )}
            </div>
        </Col>
    );
}
