@extends('layout.app')
@section('content')
    <form action="" method="POST">

        @csrf

        <div class="card">
            <div class="card-body">
                <div class="card card-secondary card-tabs">
                    <div class="card-header p-0 pt-1">
                        <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link @if ($single == false) active @endif"
                                    id="custom-tabs-one-auto-wellcome-sms-tab" data-toggle="pill"
                                    href="#custom-tabs-one-auto-wellcome-sms" role="tab"
                                    aria-controls="custom-tabs-one-auto-wellcome-sms" aria-selected="true">Batch SMS
                                    Send</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link @if ($single == true) active @endif"
                                    id="custom-tabs-one-auto-inactive-tab" data-toggle="pill"
                                    href="#custom-tabs-one-auto-inactive" role="tab"
                                    aria-controls="custom-tabs-one-auto-inactive" aria-selected="true">Single Sms Send</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link " id="custom-tabs-user-send-sms-tab" data-toggle="pill"
                                    href="#custom-tabs-user-send-sms" role="tab"
                                    aria-controls="custom-tabs-user-send-sms" aria-selected="true">User Sms Send</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link " id="custom-tabs-due-customer-send-sms-tab" data-toggle="pill"
                                    href="#custom-tabs-due-customer-send-sms" role="tab"
                                    aria-controls="custom-tabs-due-customer-send-sms" aria-selected="true">Due Customer Sms
                                    Send</a>
                            </li>

                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="tab-content" id="custom-tabs-one-tabContent">
                            <div class="tab-pane fade @if ($single == false) show active @endif"
                                id="custom-tabs-one-auto-wellcome-sms" role="tabpanel"
                                aria-labelledby="custom-tabs-one-auto-wellcome-sms-tab">
                                <div class="container col-md-12">

                                    <div class="row">
                                        <div class="form-group col-md-3">
                                            <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                                                Reseller*
                                            </label>
                                            <select class="select2 form-control select_option" name="reseller_id" id="reseller">
                                                <option value="">Select One</option>
                                                @foreach ($reseller as $item)
                                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('reseller_id')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label> Select POP </label>
                                            <select name="pop_id" id="pop"
                                                class="select2 form-control select_option">
                                                <option value=""> Select One</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-md-3">
                                            <label> Select Billing Cycle </label>
                                            <select name="billing_cycle" id="billing_cycle"
                                                class="select2 form-control select_option">
                                                <option value="all">ALL Billing Cycle</option>
                                                @foreach (explode(',', $confday) as $conf)
                                                    <option value="{{ $conf }}">{{ $conf }}</option>
                                                @endforeach
                                            </select>
                                        </div>



                                        <div class="form-group col-md-3">
                                            <label for="status" class="block text-sm font-medium text-gray-700">
                                                Status
                                            </label>
                                            <select name="status" id="status" class="select2 form-control" required
                                                multiple>
                                                <option value="">Select One</option>
                                                <option value="active">Active</option>
                                                <option value="deactive">Deactive</option>
                                                <option value="expired">Expired</option>
                                                <option value="disable">Disable</option>
                                            </select>

                                            @error('status')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="form-group col-md-3">
                                            <div class="form-group">
                                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                                    Select Area
                                                </label>
                                                <select name="area" id="area"
                                                    class="select2 form-control form-control-sm" multiple>
                                                    <option value="all">ALL Area</option>

                                                </select>

                                            </div>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <label for="message" class="block text-sm font-medium text-gray-700">
                                                Message
                                            </label>
                                            <textarea name="message" class="form-control" id="message" required>{{ old('message') }}</textarea>
                                            @error('message')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>

                                        <div class="form-group col-md-12">

                                            <textarea class="form-control" id="expire_exception_sms_fiels" spellcheck="false" rows="10" readonly>{c_id}&#10;{c_code}&#10;{c_password}&#10;{c_username}&#10;{c_name}&#10;{c_deadline}&#10;{TotalDue}&#10;{company_cell}&#10;{company_name}&#10;{payment_url}</textarea>

                                        </div>


                                    </div>
                                    <div class="form-group">
                                        <button type="button" id="submit" class="btn btn-primary float-right">
                                            Send
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade @if ($single == true) show active @endif"
                                id="custom-tabs-one-auto-inactive" role="tabpanel"
                                aria-labelledby="custom-tabs-one-auto-inactive-tab">

                                <div class="container col-md-12">

                                    <div class="row">
                                        <div class="form-group col-md-3">
                                            <label for="number" class="block text-sm font-medium text-gray-700">
                                                Single number
                                            </label>
                                            <input type="text" class="form-control" id="number" minlength="11"
                                                value="@if ($client) {{ $client->clientsinfo->contact_no }} @endif"
                                                name="number">
                                        </div>
                                        <div class="form-group col-md-5">
                                            <label for="message" class="block text-sm font-medium text-gray-700">
                                                Message
                                            </label>
                                            <textarea name="message_single" class="form-control" id="message_single" required>{{ old('message_single') }}</textarea>
                                            @error('message')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message_single }}
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label for="message"
                                                class="block text-sm font-medium text-gray-700">Keyword</label>
                                            <textarea class="form-control" id="message_single_keyword" spellcheck="false" rows="8" readonly>{c_id}&#10;{c_code}&#10;{c_password}&#10;{c_username}&#10;{c_name}&#10;{c_deadline}&#10;{TotalDue}&#10;{payment_url}&#10;{company_cell}&#10;{company_name}</textarea>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <button type="button" id="submit_single" class="btn btn-primary float-right">
                                            Send
                                        </button>
                                    </div>

                                </div>
                            </div>

                            <div class="tab-pane fade " id="custom-tabs-user-send-sms" role="tabpanel"
                                aria-labelledby="custom-tabs-user-send-sms-tab">

                                <div class="container col-md-12">

                                    <div class="row">
                                        <div class="form-group col-md-4">
                                            <label for="number" class="block text-sm font-medium text-gray-700">
                                                Select User
                                            </label>
                                            <select name="users" id="users" class="select2 form-control" required
                                                multiple>
                                                <option value="all_user">All User</option>
                                                <option value="all_manager">All Manager</option>

                                                @foreach ($users as $user)
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group col-md-8">
                                            <label for="message" class="block text-sm font-medium text-gray-700">
                                                Message
                                            </label>
                                            <textarea name="message_user" class="form-control" id="message_user" required>{{ old('message_single') }}</textarea>
                                            @error('message')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message_user }}
                                                </div>
                                            @enderror
                                        </div>



                                    </div>
                                    <div class="form-group">
                                        <button type="button" id="send_user_sms" class="btn btn-primary float-right">
                                            Send
                                        </button>
                                    </div>

                                </div>
                            </div>
                            <div class="tab-pane fade " id="custom-tabs-due-customer-send-sms" role="tabpanel"
                                aria-labelledby="custom-tabs-due-customer-send-sms-tab">

                                <div class="container col-md-12">
                                    <div class="row">
                                        <div class="form-group col-md-3">
                                            <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                                                Reseller
                                            </label>
                                            <select class="select2 form-control select_option reseller_id" name="reseller_id"
                                                id="reseller">
                                                <option value="">Select One</option>
                                                @foreach ($reseller as $item)
                                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('reseller_id')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message }}
                                                </div>
                                            @enderror
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label> Select POP </label>
                                            <select name="pop_id" id="pop"
                                                class="select2 form-control select_option pop_id">
                                                <option value=""> Select One</option>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <div class="form-group">
                                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                                    Select Area
                                                </label>
                                                <select name="due_area" id="due_area"
                                                    class="select2 form-control form-control-sm due_area" multiple>

                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-3 col-sm-3 col-xs-3">
                                            <div class="form-group">
                                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                                    Billing Cycle
                                                </label>
                                                <select name="due_cutomer_send_sms_billing_cycle"
                                                    id="due_cutomer_send_sms_billing_cycle"
                                                    class="select2 form-control form-control-sm" multiple>
                                                    <option value="all">ALL Billing Cycle</option>
                                                    @foreach (explode(',', $confday) as $conf)
                                                        <option value="{{ $conf }}">{{ $conf }}</option>
                                                    @endforeach

                                                </select>

                                            </div>
                                        </div>


                                        <div class="col-md-3 col-sm-3 col-xs-3">
                                            <div class="form-group">
                                                <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                                    Status
                                                </label>
                                                <select name="due_customer_send_sms_status"
                                                    id="due_customer_send_sms_status"
                                                    class="select2 form-control form-control-sm" multiple>
                                                    {{-- <option value="all">All</option> --}}
                                                    <option value="active">Active Customerr</option>
                                                    <option value="disable">Disable Customer</option>
                                                    <option value="expired">Expired Customer</option>
                                                    <option value="deactive">Deactive Customer</option>
                                                </select>

                                            </div>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <label for="message" class="block text-sm font-medium text-gray-700">
                                                Message
                                            </label>
                                            <textarea name="message_due_customer" class="form-control" id="message_due_customer" required>{{ old('message_single') }}</textarea>
                                            @error('message')
                                                <div class="alert alert-danger mt-1">
                                                    {{ $message_due_customer }}
                                                </div>
                                            @enderror
                                        </div>

                                        <div class="form-group col-md-12 text-right">
                                            <button type="button" id="send_sms_to_due_customer"
                                                class="btn btn-primary float-right mb-1">
                                                Send
                                            </button>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">

                                        <textarea class="form-control" id="expire_exception_sms_fiels" spellcheck="false" rows="10" readonly>{c_id}&#10;{c_code}&#10;{c_password}&#10;{c_username}&#10;{c_name}&#10;{c_deadline}&#10;{TotalDue}&#10;{company_name}&#10;{company_cell}&#10;{payment_url}</textarea>

                                    </div>



                                </div>
                            </div>

                        </div>
                    </div>

                </div>



            </div>

        </div>

    </form>
    <style>
        #processing {
            background: rgba(0, 0, 0, .5);
            height: 100vh;
            width: 100%;
            text-align: center;
            color: #fff;
            top: 0;
            padding-top: 50vh%;
            position: fixed;
            z-index: 999;
        }
    </style>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerAreaPop') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').empty();
                        $('#pop').append('<option value="all"> All Pop </option>');
                        result.pops.forEach(element => {
                            $('#pop').append('<option value="' + element.id + '">' +
                                element.popname + '</option>');
                        });

                        $('#area').empty();
                        $('#area').append('<option value="all" selected> All Area </option>');
                        result.areas.forEach(element => {

                            if (element != "") {
                                $('#area').append('<option value="' + element + '">' +
                                    element + '</option>');
                            }

                        });

                        $('#processing').remove();
                    }
                });
            });

            $('#submit').on('click', function(e) {

                e.preventDefault();
                $('#processing').show();
                let reseller_id = $('#reseller').val();
                let pop_id = $('#pop').val();
                let status = $('#status').val();
                let message = $('#message').val();
                let areas = $('#area').val();
                let billing_cycle = $('#billing_cycle').val();
                let singel_number = null;




                $.ajax({
                    type: 'post',
                    url: '{{ route('sendSmsToSelectedPop') }}',
                    data: {
                        reseller_id: reseller_id,
                        pop_id: pop_id,
                        billing_cycle: billing_cycle,
                        status: status,
                        message: message,
                        singel_number: singel_number,
                        areas: areas,
                    },
                    beforeSend: function() {
                        if (confirm('Are you Sure?')) {
                            return true;
                        } else {
                            $('#processing').remove();
                            return false;
                        }
                    },
                    success: function(result) {
                        if (result.error) {
                            toastr.error(result.error, 'Error');
                        }

                        if (result.success) {
                            $('#processing').hide();
                            toastr.success(result.success, 'Success');
                            $('.select').each(function() {
                                $(this).val("").trigger("change");
                            });
                            $('#message').val('');
                            // $("#status").val("").trigger( "change" );
                            // $("option:selected").prop("selected", true);


                        }

                        $('#processing').remove();
                    }
                });
            });

            $('#submit_single').on('click', function(e) {

                e.preventDefault();
                $('body').prepend('<div id="processing">processing.....</div>');
                let reseller_id = $('#reseller').val();
                let pop_id = $('#pop').val();
                let status = $('#status').val();
                let message = $('#message_single').val();
                let singel_number = $('#number').val();




                $.ajax({
                    type: 'post',
                    url: '{{ route('sendSmsToSelectedPop') }}',
                    data: {
                        reseller_id: reseller_id,
                        pop_id: pop_id,
                        status: status,
                        message: message,
                        singel_number: singel_number
                    },
                    beforeSend: function() {
                        if (confirm('Are you Sure?')) {
                            return true;
                        } else {
                            $('#processing').remove();
                            return false;
                        }
                    },
                    success: function(result) {

                        if (result.error) {
                            toastr.error(result.error, 'Error');
                        }

                        if (result.success) {
                            toastr.success(result.success, 'Success');

                            $('#message_single').val('');
                            $('#number').val('');


                        }

                        $('#processing').remove();
                    }
                });
            });

            $('#send_user_sms').click(function() {
                // console.log('comes');
                let users = $('#users').val();
                let message = $('#message_user').val();
                $('body').prepend('<div id="processing">processing.....</div>');

                $.ajax({
                    type: 'post',
                    url: '{{ route('sendSmsToSelectedUser') }}',
                    data: {
                        users: users,
                        message: message
                    },
                    beforeSend: function() {
                        if (confirm('Are you Sure?')) {
                            return true;
                        } else {
                            $('#processing').remove();
                            return false;
                        }
                    },
                    success: function(result) {
                        // console.log(result);
                        if (result.error) {
                            toastr.error(result.error, 'Error');
                        }

                        if (result.success) {
                            toastr.success(result.success, 'Success');
                            $("#users").val("").trigger("change");
                            $('#message_user').val('');
                        }

                        $('#processing').remove();
                    }
                });
            });

            $('#send_sms_to_due_customer').click(function() {
                let reseller_id = $('.reseller_id').val();
                let pop_id = $('.pop_id').val();
                let due_area = $('#due_area').val();
                let billing_cycle = $('#due_cutomer_send_sms_billing_cycle').val();
                let status = $('#due_customer_send_sms_status').val();
                let message = $('#message_due_customer').val();
                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'post',
                    url: '{{ route('sendSmsToDueCustomer') }}',
                    data: {
                        reseller_id: reseller_id,
                        pop_id: pop_id,
                        areas: due_area,
                        billing_cycle: billing_cycle,
                        status: status,
                        message: message
                    },
                    beforeSend: function() {
                        if (confirm('Are you Sure?')) {
                            return true;
                        } else {
                            $('#processing').remove();
                            return false;
                        }
                    },
                    success: function(result) {
                        $('#loading').remove();
                        if (result.error) {
                            toastr.error(result.error, 'Error');
                        }

                        if (result.success) {
                            toastr.success(result.success, 'Success');
                            $("#users").val("").trigger("change");
                            $('#message_user').val('');
                        }

                        $('#processing').remove();
                    }
                });
            });

            $('.reseller_id').on('change', function(e) {
                e.preventDefault();
                $('#processing').show();

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('.pop_id').html(result);
                        $('#processing').hide();
                    }
                });

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerWiseArea') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#due_area').html(result);
                        $('#loading').remove();
                    }
                });
            });

        });
    </script>
@endsection
