@extends('layout.app')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-md-6">
                <div class="form-group">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                        From Date
                    </label>
                    <div class="input-group date" id="searchFrom" data-target-input="nearest">
                        <input type="text" name="from_date" value="{{$from->format('m/d/y')}}"
                            class="form-control datetimepicker-input input-group-append"
                            data-toggle="datetimepicker" data-target="#searchFrom"
                            autocomplete="off">

                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                        To Date
                    </label>
                    <div class="input-group date" id="searchTo" data-target-input="nearest">
                        <input type="text" name="to_date" value="{{$to->format('m/d/y')}}"
                            class="form-control datetimepicker-input input-group-append"
                            data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group float-right mt-2">

                    <button  class="btn btn-primary" type="submit"
                            id="searchBtn"><i class="fa fa-search"></i> Search</button>

                </div>
            </div>


        </div>
        <div class="d-flex justify-content-end mb-3">
            <button class="btn btn-success mr-2" id="downloadExcel">Download Excel</button>
            <button class="btn btn-danger" id="downloadPDF">Download PDF</button>
        </div>

        <div class="table-responsive">

            @include('report.marketingNewClient.result')
        </div>
    </div>
</div>

@endsection

@section('ajax')
<script src="{{ asset('/') }}js/xlsx/xlsx.full.min.js"></script>
<script src="{{ asset('/') }}js/html2pdf/html2pdf.bundle.min.js"></script>

<script>
    // Excel Export
    document.getElementById("downloadExcel").addEventListener("click", function () {
        let table = document.getElementById("tableId");
        let ws = XLSX.utils.table_to_sheet(table);

        // Auto-fit column width
        let wscols = [];
        for (let i = 0; i < table.rows[0].cells.length; i++) {
            wscols.push({ wch: table.rows[0].cells[i].innerText.length + 5 });
        }
        ws['!cols'] = wscols;

        let wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, "Report");
        XLSX.writeFile(wb, "Report.xlsx");
    });

    // PDF Export
    document.getElementById("downloadPDF").addEventListener("click", function () {
        let element = document.getElementById("result");
        let opt = {
            margin:       10,
            filename:     'Report.pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 3 }, // Increase scale for better quality
            jsPDF:        { unit: 'mm', format: 'a4', orientation: 'landscape' }
        };
        html2pdf().set(opt).from(element).save();
    });

    $(document).ready(function() {

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                let from = $('#searchFrom input').val();
                let to = $('#searchTo input').val();

                $.ajax({
                    type: 'get',
                    url: '{{ route('kam-report-search') }}',
                    data: {
                        from: from,
                        to: to
                    },
                    success: function(result) {
                        $('#result').html(result);
                    }
                });
            });


        });
</script>
@endsection
