<?php

namespace App\Models\map;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TjBox extends Model
{
    use HasFactory;
    protected $table = "tj_box_map";
    protected $fillable = [
        "name",
        "coordinates",
        "type",
        "remarks",
    ];

    protected $morphClass = 'tjBox';

    public function upStream()
    {
        return $this->hasMany(Cable::class, "endNodeId")->where("endNodeType", "tjBox");
    }
    public function downStream()
    {
        return $this->hasMany(Cable::class, "startNodeId")->where("startNodeType", "tjBox");
    }
}
