@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">
                <i class="fas fa-wallet mr-1"></i>
                Balance API
            </h3>
        </div>
        <div class="card-body">
            @if ($error)
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle mr-2"></i>
                    <strong>Error:</strong> {{ $error }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            @if ($gateway)
                <div class="row mb-3">
                    <div class="col-md-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-info">
                                <i class="fas fa-server"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Active Gateway</span>
                                <span class="info-box-number">{{ $gateway->name }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                @if ($balance !== null)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card card-success card-outline">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-coins mr-1"></i>
                                        Current Balance
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="text-center">
                                        <h1 class="display-4 text-success mb-3">
                                            <i class="fas fa-money-bill-wave"></i>
                                            {{ number_format((float) $balance, 2) }}
                                        </h1>
                                        <p class="text-muted">Remaining balance in your account</p>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="button" class="btn btn-primary btn-sm" onclick="location.reload()">
                                        <i class="fas fa-sync-alt mr-1"></i>
                                        Refresh Balance
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif(!$error)
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        Unable to retrieve balance information. Please try again.
                    </div>
                @endif
            @else
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    No active voice gateway configured. Please enable a voice gateway first.
                </div>
            @endif

        </div>
    </div>
@endsection
