<button id="downloadCsv" class=" btn btn-primary" >
    Download CSV
</button>
@if (checkAPI())
    <h5>Total Online: {{ $count }}</h5>
    <div class="table-responsive">

        <table id="dataTable" class="table table-bordered table-striped">
            <thead class="custom-table-head">
                <tr>
                    <th scope="col"> User ID </th>
                    <th scope="col">Name</th>
                    <th scope="col"> Client IP </th>
                    <th scope="col"> NAS IP </th>
                    <th scope="col"> MAC Address </th>
                    <th scope="col"> Uptime </th>
                    <th scope="col"></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @php
                    $clientCount = 0;
                @endphp
                @foreach ($allMikrotikAndActiveUsers as $mikrotikAndActiveUsers)
                    @foreach ($mikrotikAndActiveUsers['activeUsers'] as $client)
                        <tr>
                            <td>
                                {{ $client['name'] }}
                            </td>
                            <td>{{ $client['client_name'] }}</td>
                            <td>
                                {{ $client['address'] }}
                            </td>

                            <td>
                                {{ $mikrotikAndActiveUsers['nasIp'] }}
                            </td>

                            <td>
                                {{ $client['caller-id'] }}
                            </td>

                            <td>
                                {{-- {{ $client['uptime'] }} --}}
                                {{ formatUptime($client['uptime']) }}

                                {{-- @php
                                $clientCount++;
                                    // Extract the initial uptime in seconds, considering days (e.g., "1d12h5m46s")
                                    preg_match('/(\d+)d(\d+)h(\d+)m(\d+)s/', $client['uptime'], $matches);
                                    $days = $matches[1] ?? 0;
                                    $hours = $matches[2] ?? 0;
                                    $minutes = $matches[3] ?? 0;
                                    $seconds = $matches[4] ?? 0;

                                    // Calculate total seconds
                                    $totalSeconds = ($days * 86400) + ($hours * 3600) + ($minutes * 60) + $seconds;
                                @endphp
                                <div id="uptime{{ $clientCount }}"></div>

                                <script>
                                    $(document).ready(function () {
                                        let totalSeconds = {{ $totalSeconds }};

                                        function formatTime(seconds) {
                                            const days = Math.floor(seconds / 86400); // Calculate days
                                            const hours = Math.floor((seconds % 86400) / 3600); // Remaining hours
                                            const minutes = Math.floor((seconds % 3600) / 60); // Remaining minutes
                                            const secs = seconds % 60; // Remaining seconds

                                            return (days > 0 ? `${days}d ` : '') + // Add days if > 0
                                                `${String(hours).padStart(2, '0')}:` +
                                                `${String(minutes).padStart(2, '0')}:` +
                                                `${String(secs).padStart(2, '0')}`;
                                        }

                                        let idName = 'uptime{{ $clientCount }}';

                                        function updateUptime() {
                                            const $uptimeDiv = $(`#${idName}`);
                                            $uptimeDiv.text(formatTime(totalSeconds));
                                            totalSeconds++; // Increment the time by 1 second
                                        }

                                        // Initial display and start the timer
                                        updateUptime();
                                        setInterval(updateUptime, 1000); // Update every second
                                    });
                                </script> --}}
                            </td>

                            <td class="px-6 text-center text-sm font-medium">
                                <a href="{{ route('clients.show', $clients[$client['name']]) }}"
                                    class="noprint btn btn-primary btn-xs btn-block mb-1">View live Traffice</a>
                                @can('onlineUserDisconnection')
                                    <a href="{{ route('userDisconnect', $client['name']) }}"
                                        class="btn btn-danger">Disconnect</a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                @endforeach





                <!-- More items... -->
            </tbody>
        </table>

        <div class="p-5">
            {{-- {{ $list->links() }} --}}
        </div>
    </div>
@else
    <h5>Total Online: {{ $list->count() }}</h5>
    {{-- @can('discount-online-all')
        @if ($list->count() > 0)
            <a onclick="return confirm('Are you sure you want disconnect ?');" href="{{ route('disconnectAll') }}"
                class="btn btn-danger float-right">Disconnect All</a>
        @endif
    @endcan --}}
    <div class="table-responsive">
        <table id="dataTable" class="table table-bordered">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col"> User ID </th>
                    @if (checkSettings('client_name_in_online_list') == 'enable')
                        <th scope="col">Name</th>
                    @endif
                    <th scope="col"> Client IP </th>
                    <th scope="col"> NAS IP </th>
                    <th scope="col"> MAC Address </th>
                    <th scope="col"> Last Update </th>
                    <th scope="col"> Uptime </th>
                    <th>Date</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">


                @foreach ($list as $r)
                    <tr>
                        <td> {{ $r->username }} </td>
                        @if (checkSettings('client_name_in_online_list') == 'enable')
                            <td> {{ $r->clients_name ?? '' }} </td>
                        @endif
                        <td> {{ $r->framedipaddress }} </td>
                        <td> {{ $r->nasipaddress }} </td>
                        <td> {{ $r->callingstationid }} </td>
                        <td> {{ $r->acctupdatetime }}</td>
                        <td> {{ \Carbon\Carbon::parse($r->acctstarttime)->diffForHumans() }} </td>
                        <td> {{ $r->acctstarttime }} </td>

                        <td class="px-6 text-center text-sm font-medium">
                            @if (checkSettings('show-traffice') == 'enable')
                                <a href="{{ route('clients-with-userName', $r->username) }}"
                                    class="noprint btn btn-primary btn-xs btn-block  mb-1">View live Traffice</a>
                            @endif
                            @can('onlineUserDisconnection')
                                <a href="{{ route('onlineUserDisconnect') }}?id={{ $r->username }}"
                                    class="btn btn-danger">Disconnect</a>
                            @endcan


                        </td>
                    </tr>
                @endforeach


                <!-- More items... -->
            </tbody>
        </table>

        <div class="p-5">
            @can('discount-online-all')
                @if ($list->count() > 0)
                    <a onclick="return confirm('Are you sure you want disconnect ?');" href="{{ route('disconnectAll') }}"
                        class="btn btn-danger float-right">Disconnect All</a>
                @endif
            @endcan
            {{-- {{ $list->links() }} --}}
        </div>
    </div>
@endif
