<?php

use App\Http\Controllers\BandProviderController;
use App\Http\Controllers\BandPurchaseController;
use App\Http\Controllers\BandServiceController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BandwdtihSaleController;
use App\Http\Controllers\BandwidthSale\BandwidthClientController;
use App\Http\Controllers\BwBillCollectionController;

    Route::resource('band-provider', BandProviderController::class);
    Route::resource('band-service', BandServiceController::class);
    Route::resource('band-purchase', BandPurchaseController::class);
    Route::resource('bw-sale', BandwdtihSaleController::class);
    Route::resource('bw-customer', BandwidthClientController::class);
    Route::resource('bw-bill-collect', BwBillCollectionController::class);
    Route::get('recurring-invoice', [BwBillCollectionController::class, 'recurringInvoice'])->name('recurringInvoice');

    Route::get('bandwidth-report', [BandPurchaseController::class, 'bandwidthReport'])->name('bandwidthReport');
    Route::get('bandwidthSearch', [BandPurchaseController::class, 'bandwidthSearch'])->name('bandwidthSearch');
    Route::get('checkInvoiceNo', [BandPurchaseController::class, 'checkInvoiceNo'])->name('checkInvoiceNo');

    Route::get('bandwidth-sale-report', [BandwdtihSaleController::class, 'bandwidthSaleReport'])->name('bandwidthSaleReport');
    Route::get('bandwidthSaleSearch', [BandwdtihSaleController::class, 'bandwidthSaleSearch'])->name('bandwidthSaleSearch');
