<?php

namespace App\Http\Controllers;

use App\Models\Banking;
use App\Models\BankTransfar;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class BankTransfarController extends Controller
{

    public function index()
    {
        $bank_transfar = BankTransfar::orderBy('id', 'desc')->paginate(50);
        return view("banking.bank_transfar", [
            'page_title' => "Bank Transfar",
            'bank_transfar' => $bank_transfar,
        ]);
    }

    public function diposit()
    {
        $account_information = Banking::where('status', 1)->get();
        return view("banking.diposit", [
            'page_title' => "Bank Account Diposit",
            'bank_accounts' => $account_information,
        ]);
    }

    public function dipositStore(Request $request)
    {
        $request->validate([
            'account_id' => 'required',
            'diposit_amount' => 'required',
            'by' => 'required',
        ]);
        $diposit = new BankTransfar();

        $diposit->account_id = $request->account_id;
        $diposit->diposit_amount = $request->diposit_amount;
        $diposit->description = $request->description;
        $diposit->by = $request->by;
        $diposit->save();

        Toastr::success('Bank Account Deposit Successfully', 'Success');
        return back();
    }

    public function withdraw()
    {
        $account_information = Banking::where('status', 1)->get();
        return view("banking.withdraw", [
            'page_title' => "Bank Account withdraw",
            'bank_accounts' => $account_information,
        ]);
    }

    public function withdrawStore(Request $request)
    {
        $request->validate([
            'account_id' => 'required',
            'withdraw_amount' => 'required',
            'by' => 'required',
        ]);

        $balance = Banking::find($request->account_id)->opening_balance;

        foreach (BankTransfar::where('account_id', $request->account_id)->get() as $transection) {
            $total_deposit = $transection->sum('diposit_amount');
            $total_withdrawal = $transection->sum('withdraw_amount');

            $balance += $total_deposit - $total_withdrawal;
        }

        if($request->withdraw_amount > $balance){
            Toastr::error('Withdraw Amount is greater than Balance', 'Error');
            return back();
        }
        $withdraw = new BankTransfar();
        $withdraw->account_id = $request->account_id;
        $withdraw->check_no = $request->check_no;
        $withdraw->withdraw_amount = $request->withdraw_amount;
        $withdraw->description = $request->description;
        $withdraw->by = $request->by;
        $withdraw->save();

        Toastr::success('Bank Account Withdraw Successfully', 'Success');
        return back();
    }

    public function approve($id)
    {
        $transection = BankTransfar::find($id);
        $transection->status = 1;
        $transection->save();

        Toastr::success('Bank Account Transection Approve Successfully', 'Success');
        return back();
    }

    public function edit($id)
    {
        $transection = BankTransfar::find($id);

        $account_information = Banking::where('status', 1)->get();

        if($transection->diposit_amount != null){
            return view("banking.diposit_edit", [
                'page_title' => "Bank Account Diposit Edit",
                'bank_accounts' => $account_information,
                'transection' => $transection,
            ]);
        }else{
            return view("banking.withdraw_edit", [
                'page_title' => "Bank Account Withdraw Edit",
                'bank_accounts' => $account_information,
                'transection' => $transection,
            ]);
        }
    }

    public function dipositupdate(Request $request, $id)
    {
        $request->validate([
            'account_id' => 'required',
            'diposit_amount' => 'required',
            'by' => 'required',
        ]);

        $transection = BankTransfar::find($id);

        $transection->account_id = $request->account_id;
        $transection->diposit_amount = $request->diposit_amount;
        $transection->description = $request->description;
        $transection->by = $request->by;
        $transection->save();

        Toastr::success('Bank Account Transection Update Successfully', 'Success');
        return redirect()->route('bank.index');
    }

    public function withdrawupdate(Request $request, $id)
    {
        $request->validate([
            'account_id' => 'required',
            'withdraw_amount' => 'required',
            'by' => 'required',
        ]);

        $balance = Banking::find($request->account_id)->opening_balance;

        foreach (BankTransfar::where('account_id', $request->account_id)->get() as $transection) {
            $total_deposit = $transection->sum('diposit_amount');
            $total_withdrawal = $transection->sum('withdraw_amount');

            $balance += $total_deposit - $total_withdrawal + BankTransfar::find($id)->withdraw_amount;
        }

        if($request->withdraw_amount > $balance){
            Toastr::error('Withdraw Amount is greater than Balance', 'Error');
            return back();
        }

        $transection = BankTransfar::find($id);

        $transection->account_id = $request->account_id;
        $transection->check_no = $request->check_no;
        $transection->withdraw_amount = $request->withdraw_amount;
        $transection->description = $request->description;
        $transection->by = $request->by;
        $transection->save();

        Toastr::success('Bank Account Transection Update Successfully', 'Success');
        return redirect()->route('bank.index');
    }

    public function delete($id)
    {
        $transection = BankTransfar::find($id);
        $transection->delete();

        Toastr::success('Bank Account Transection Delete Successfully', 'Success');
        return back();
    }
}
