@extends('layout.app')
@section('content')

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
                    <table id="dataTable" class="table table-bordered">
                        <thead class="bg-gray-50">
                           <tr>
                               <th>SL</th>
                               <th>Permission Name</th>
                               <th>Status</th>
                               <th>Action</th>
                           </tr>
                            
                        </thead>
                        <tbody>

                            @foreach ($list as $r)
                            
                            <tr>
                                <td>{{$r->id }}</td>
                                <td>{{$r->name}}</td>
                                <td class="text-center">
                                    @if($r->status=='enable') <span class="text-green-300">Enabled</span>
                                    @elseif($r->status =='disable') <span class="text-red-300">Disabled</span>
                                    @endif 
                                </td>
                                <td class="text-center">

                                    <a href="{{route('permissions.edit',$r->id)}}" 
                                        class="btn btn-primary">
                                        Edit</a>
                                </td>
                            </tr>

                            @endforeach

                            <!-- More items... -->
                        </tbody>
                    </table>
        </div>
    </div>
</div>




@endsection

