@extends('layout.app')
@section('content')

<div class="card">
    <div class="card-body">
        <h4 class="">Transection Information</h4>
        <hr>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="thead-dark">
                    <tr>
                        <th scope="col">Date</th>
                        <th scope="col">Account Name</th>
                        <th scope="col">Account No</th>
                        <th scope="col">Check No</th>
                        <th scope="col">Bank Name</th>
                        <th scope="col">Branch Name</th>
                        <th scope="col">Discription</th>
                        <th scope="col">Deposit/Withdraw By</th>
                        <th scope="col">Diposit Amount(TK)</th>
                        <th scope="col">Withdraw Amount(TK)</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($bank_transfar as $transfar)
                        <tr>
                            <th>{{ $transfar->created_at->format('d-m-Y') }}</th>
                            <td>{{ $transfar->bank->account_name }}</td>
                            <td>{{ $transfar->bank->account_no }}</td>
                            <td>{{ $transfar->check_no }}</td>
                            <td>{{ $transfar->bank->bank_name }}</td>
                            <td>{{ $transfar->bank->branch_name }}</td>
                            <td>{{ $transfar->description }}</td>
                            <td>{{ $transfar->by }}</td>
                            <td>{{ $transfar->diposit_amount }}</td>
                            <td>{{ $transfar->withdraw_amount }}</td>
                            <td class="text-center">
                                <div class="btn-group" role="group" aria-label="Basic example">
                                    {{-- @if ($transfar->status == 0)
                                        <a href="{{ route('bank.approve', $transfar->id) }}" class="btn btn-warning btn-sm">Disapproved</a>
                                    @else
                                        <button type="button" class="btn btn-success btn-sm">Approved</button>
                                    @endif --}}

                                    <a href="{{ route('bank.edit', $transfar->id) }}" class="btn btn-info btn-sm">Edit</a>
                                    <form action="{{ route('bank.delete', $transfar->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this item?')" class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $bank_transfar->links() }}
        </div>
    </div>
</div>

@endsection

@push('js')

@endpush
