<?php

namespace App\Http\Controllers;

use App\Models\BandProvider;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;

class BandProviderController extends Controller
{

    public function index()
    {
        $data = [
            'list' => BandProvider::all()
        ];
        return view('provider.index', $data);
    }

    public function create()
    {
        return view('provider.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'company_name' => 'required',
            'contact_person' => 'required',
            'email' => 'unique:band_providers,email',
            'phone_no' => 'required|unique:band_providers|digits:11,phone_no',
        ]);
        $provider = new BandProvider();
        $provider->fill($request->all());

        if ($request->document != null) {
            $fileName = time() . '.' . $request->document->extension();
            $request->document->move(storage_path('app/public/bandProvider'), $fileName);
            $provider->document = $fileName;
        }
        $provider->save();

        Toastr::success('Information inserted Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->back();
        // $request->session()->flash('success_message', 'Branch Update successfull');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = [
            'provider' => BandProvider::find($id)
        ];

        return view('provider.edit', $data);
    }

    public function update(Request $request)
    {
        $provider = BandProvider::find($request->id);
        $this->validate($request, [
            'company_name' => 'required',
            'contact_person' => 'required',
            'email' => 'unique:band_providers,email,' . $provider->id,
            'phone_no' => 'required|unique:band_providers,phone_no,' . $provider->id,
            // 'phone_no' => 'required|unique:band_providers|digits:11,phone_no,' . $provider->id,
        ]);
        $provider->fill($request->all());

        if ($request->document != null) {
            $fileName = time() . '.' . $request->document->extension();
            $request->document->move(storage_path('app/public/bandProvider'), $fileName);
            $provider->document = $fileName;
        }
        $provider->update();

        Toastr::success('Information updated Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->route('band-provider.index');
    }

    public function destroy($id)
    {
        $provider = BandProvider::find($id);
        $provider->delete();

        Toastr::error('Information deleted Successfully!.', '', ["closeButton" => "true", "progressBar" => "true"]);
        return redirect()->back();
    }
}
