@extends('layout.app')


@section('content')
    <div class="table-responsive" id="result">
        <table id="dataTable" class="table table-bordered table-striped table-condensed">
            <thead>
                <tr class="bg-black">
                    <th>Payment Number</th>
                    <th>Amount</th>
                    <th>TrxID</th>
                    <th>Reference</th>
                    <th>Date Time</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $values = [];
                    $count = 1;
                @endphp

                @foreach ($bkashWebhookReport as $item)
                    @php
                        $info = json_decode($item->payload);
                        $value = json_decode($info->Message);
                        $values[] = $value;
                    @endphp
                @endforeach

                @foreach ($values as $value)
                    <tr style="{{ (isset($value->transactionReference)) ? '' : 'background-color: red' }}">

                        <td>
                            @if (isset($value->debitMSISDN))
                                {{ $value->debitMSISDN }}
                            @endif
                        </td>
                        <td>
                            {{ $value->amount }}
                        </td>
                        <td>
                            {{ $value->trxID }}
                        </td>
                        <td>
                            @if (isset($value->transactionReference))
                                {{ $value->transactionReference }}
                            @endif
                        </td>
                        <td>
                            {{ \Carbon\Carbon::parse($value->dateTime)->format('Y-m-d H:i:s') }}
                        </td>
                    </tr>
                    @php
                        $count++;
                    @endphp
                @endforeach


                <!-- More items... -->
            </tbody>
        </table>
        {{-- {{ $bkashWebhookReport->links() }} --}}
    </div>
@endsection
