@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Service List</h3>
            <div class="card-tools">
                <a href="{{ route('band-service.create') }}"><button class="btn btn-sm btn-primary"><i
                    class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Service</button></a>
            </div>
        </div>

        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th> ID </th>
                            <th> Name </th>
                            <th> Description </th>
                            <th> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($list as $row)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $row->name }}</td>
                                <td>{{ $row->description }}</td>
                                <td>
                                    <div class="row">
                                        <div>
                                            <a href="{{ route('band-service.edit', $row->id) }}"
                                                class="btn btn-warning">Edit</a>
                                        </div>
                                        {{-- <div class="ml-2">
                                            <form method="POST" action="{{ route('band-provider.destroy', $row->id) }}">
                                                @method('delete')
                                                @csrf

                                                <button type="submit" class="btn btn-danger">Delete</button>
                                            </form>
                                        </div> --}}
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
