@extends('layout.app')

@section('content')

    <div class="card">
        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="table ">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                ID
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                User Name
                            </th>

                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Password
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Auth Date
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                MAC Address
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                NAS Identifier
                            </th>
                            <th scope="col"
                                class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Reply
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">

                        @foreach ($login_attempts as $r)

                            <tr>
                                <td class="whitespace-nowrap">
                                    {{ $r->id }}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ $r->username ?? '' }}
                                </td>

                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->pass ?? '' }}
                                </td>

                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->authdate ?? '' }}
                                </td>
                                <td class="whitespace-nowrap text-sm text-gray-500">
                                    {{ $r->mac ?? '' }}
                                </td>

                                <td class="whitespace-nowrap">
                                    {{ $r->mikrotik ?? '' }}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ $r->reply ?? '' }}
                                </td>
                            </tr>

                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>

            <div class="p-5">
                {{-- {{ $login_attempts->links() }} --}}
            </div>

        </div>
    </div>

    {{-- <x-Custom.modal modalTitle="Reseller Recharge">
    <x-Custom.inputGroup inputName="amount" labelName="Amount" labelIcon="" placeholder="0" inputType="number" required="required"/>
    <x-Custom.formUpdateBtn value="Recharge" class="float-right bg-blue-300 mt-2"/>
  </x-Custom.modal> --}}


@endsection


@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
    </script>
@endsection
