@extends('layout.app')


@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-primary">
                        <div class="card-header bg-light">

                            <h3 class="card-title" style="color:#115548;">Edit Income</h3>
                            <div class="card-tools">
                                <a href="{{ route('income.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;See List</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        {{-- 'model'=> $model --}}
                        <!-- form start -->
                        <form method="POST" action="{{ route('income.update', $model->id) }}"
                            enctype="multipart/form-data" name="editForm">
                            @method('put')
                            @csrf


                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label for="shortname">
                                            Name*
                                        </label>
                                        <input type="text" name="name" class="form-control" placeholder="Enter Name"
                                            value="{{ $model->name }}" required>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="shortname">
                                            Income Head*
                                        </label>
                                        <select name="incomeHead" class="form-control">
                                            <option value="">Select One</option>
                                            @foreach ($incomeHead as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="shortname">
                                            Invoice Number*
                                        </label>
                                        <input type="text" name="invoice_number" class="form-control"
                                            placeholder="Enter Invoice Number" value="{{ $model->invoice_number }}"
                                            required>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="shortname">
                                            Date*
                                        </label>
                                        <input type="date" name="date" class="form-control" placeholder="Enter Date"
                                            value="{{ $model->date }}" required>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label for="shortname">
                                            Amount*
                                        </label>
                                        <input type="number" name="amount" class="form-control" placeholder="Enter Amount"
                                            value="{{ $model->amount }}" required>
                                    </div>
                                    <div class="form-group col-md-4">

                                        <label for="Attachment" class="control-label">Upload Documents</label>
                                        <input placeholder="Upload Attachment" class="form-control" name="attach_document"
                                            type="file" autocomplete="off">


                                        @if ($model->attach_document != null)
                                            <img src="{{ asset('storage/attachDocument/' . $model->attach_document) }}"
                                                style="width: 100px; height:100px;">
                                            {{-- <iframe
                                            src="{{ asset('storage/attachDocument/' . $model->attach_document) }}"></iframe> --}}
                                            <input type="hidden" name="id" value="{{ $model->id }}">
                                        @else
                                            <input type="hidden" name="id" value="{{ $model->id }}">
                                        @endif

                                    </div><br>
                                    <div class="form-group col-md-12">
                                        <label for="shortname">
                                            Description*
                                        </label>
                                        <textarea name="description" class="form-control"
                                            placeholder="Type Description"> {{ $model->description }}</textarea>
                                    </div>
                                </div>
                                <div class="form-group float-right">
                                    <button type="submit" name="btn" class=" btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>
            <!-- /.row -->

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
    <script>
        document.forms['editForm'].elements['incomeHead'].value = {{ $model->incomeHead }}
    </script>
@endsection
@push('script-bottom')
@endpush
