<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSplitterOutTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('splitter_out_map', function (Blueprint $table) {
            $table->id();
            $table->timestamps();

            $table->foreignId("splitter_id");
            $table->integer("out_number");
            $table->string("type")->default("splitter_out");

            $table->foreignId("fiber_id")->nullable();
            $table->foreignId("cable_id")->nullable();

            $table->string("connected_component_type")->nullable();
            $table->foreignId("connected_component_id")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('splitter_out_map');
    }
}
