<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard-billing-info')): ?>
    <section class="card">
        <div class="card-header">
            <h1 class="card-title float-none ">Monthly Bill Collection [Only Own] Manager Reports
                <?php echo e(date('M')); ?>

                <?php echo e(date('Y')); ?></h1>
        </div>



        <?php if(checkSettings('d2d_manager_wise_payment_summary') == 'enable'): ?>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover table-responsive-lg">
                        <thead>
                            <tr>
                                <th scope="col" class="h6">Manager</th>
                                <th scope="col" class="h6 text-center">Bill Client</th>
                                <th scope="col" class="h6 text-right">Received Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $totalPaid = 0;
                                $totalClient = 0;
                            ?>

                            <?php $__currentLoopData = $resellers->where('reseller_type', 'own'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reseller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $rTotalBill = 0;
                                    $rTotalClient = 0;
                                ?>

                                <?php $__currentLoopData = $popWisePayment->where('reseller_id', $reseller->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $rTotalBill += $item->total_paid;
                                        $rTotalClient += $item->total_row;

                                        $totalPaid += $item->total_paid;
                                        $totalClient += $item->total_row;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <tr class="text-center">
                                    <td class="manager-bg" style="text-align: start !important;">
                                        <?php echo e($reseller->name); ?>

                                    </td>
                                    <td><?php echo e($rTotalClient); ?></td>
                                    <td class="table-data text-right">
                                        <?php echo e(number_format($rTotalBill, 2)); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr style="background: #78716C; color:#FFFFFF;">
                                <td class="h6">Total</td>
                                <td class="h6 text-center"><?php echo e($totalClient); ?></td>
                                <td class="h6 text-right"><?php echo e(number_format($totalPaid, 2)); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover table-responsive-lg ">
                        <thead>
                            <tr>
                                <th scope="col" class="h6">Manager</th>
                                <th scope="col" class="h6">Bill Client</th>
                                <th scope="col" class="h6 text-left">Bill Amount</th>
                                <th scope="col" class="h6">Received Client</th>
                                <th scope="col" class="h6 text-right">Received Amount</th>
                                <th scope="col" class="h6 text-right">Discount Amount</th>
                                <th scope="col" class="h6">Collection(%)</th>
                                <th scope="col" class="h6">Dues Clients</th>
                                <th scope="col" class="h6 text-right">Dues Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $dueClients = 0;
                                $dueAmounts = 0;
                                $clientscount = 0;
                                $totalBill = 0;
                                // $totalAdjustment = 0;
                                $totalPaid = 0;
                                $totalDiscount = 0;
                            ?>

                            

                            <?php $__currentLoopData = $resellers->where('reseller_type', 'own'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reseller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php

                                    $rTotalClient = 0;
                                    $rTotalBill = 0;
                                    $rTotalPaid = 0;
                                    $rTotalDueAmount = 0;
                                    $rTotaldueClient = 0;
                                    $rTotalDiscount = 0;

                                ?>

                                <?php $__currentLoopData = $popWiseBillReport->where('reseller_id', $reseller->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $totalBill += $item->total_bill;
                                        $clientscount += $item->total_row;
                                        $dueClients += $item->not_paid;
                                        $dueAmounts += $item->total_bill - $item->total_paid;
                                        $totalPaid += $item->total_paid;
                                        $totalDiscount += $item->total_discount;

                                        $rTotalClient += $item->total_row;
                                        $rTotalBill += $item->total_bill;
                                        $rTotalPaid += $item->total_paid;
                                        $rTotalDueAmount += $item->total_bill - $item->total_paid;
                                        $rTotaldueClient += $item->not_paid;
                                        $rTotalDiscount += $item->total_discount;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <tr class="text-center">
                                    <td class="manager-bg" style="text-align: start !important;"><?php echo e($reseller->name); ?></td>
                                    <td><?php echo e($rTotalClient); ?></td>
                                    <td class="table-data">
                                        <?php echo e($rTotalBill); ?>

                                    </td>
                                    <td><?php echo e($rTotalClient - $rTotaldueClient); ?></td>
                                    <td class="table-data"><?php echo e($rTotalPaid - $rTotalDiscount); ?></td>
                                    <td><?php echo e($rTotalDiscount); ?></td>
                                    <td class="table-data">
                                        <?php if($rTotalPaid != 0 && $rTotalBill != 0): ?>
                                            <?php echo e(round(($rTotalPaid * 100) / $rTotalBill, 2)); ?>%
                                        <?php else: ?>
                                            0%
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"><?php echo e($rTotaldueClient ?? 0); ?></td>
                                    <td class="text-center table-data"><?php echo e($rTotalBill - $rTotalPaid); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <tr style="background: #78716C; color:#FFFFFF;">
                                <td class="h6">Total</td>
                                <td class="h6 text-center"><?php echo e($clientscount); ?></td>
                                <td class="h6 text-center"><?php echo e($totalBill); ?></td>
                                <td class="h6 text-center"><?php echo e($clientscount - $dueClients); ?></td>
                                <td class="h6 text-center"><?php echo e(round($totalPaid) - round($totalDiscount)); ?></td>
                                <td class="h6 text-center"><?php echo e(round($totalDiscount)); ?></td>
                                <td class="h6">
                                    <span class="text-center">
                                        <?php if($totalBill != 0): ?>
                                            <?php echo e(number_format(($totalPaid * 100) / $totalBill, 2)); ?> %
                                        <?php else: ?>
                                            0%
                                        <?php endif; ?>
                                    </span>

                                </td>
                                <td class="h6 text-center">
                                    <?php echo e($dueClients); ?>

                                </td>

                                <td class="h6 text-center">
                                    <span class="text-default">
                                        <?php echo e(round($dueAmounts)); ?>

                                    </span>
                                </td>

                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>


    </section>


<?php endif; ?>


<style>
    .card-title {
        font-size: 32px !important;
        text-align: center !important;
        letter-spacing: 0.10rem;
        font-weight: 500;
    }

    .manager-bg {
        background-color: rgb(221 214 254 / 0.05);
        --tw-text-opacity: 1;
        color: rgb(3 7 18 / var(--tw-text-opacity));
    }

    .table-data {
        background-color: rgb(255 241 242 / 0.5);
        --tw-text-opacity: 1;
        color: rgb(15 23 42 / var(--tw-text-opacity));
    }
</style>
<?php /**PATH /var/www/html/abrarnetwork/radius-circle/resources/views/dashboard/new/resellerWiseReport.blade.php ENDPATH**/ ?>