import { useEffect, useState } from 'react';
import { Col, Form } from 'react-bootstrap';
import axiosInstance from '../../../../../util/axiosInstance';
import { getColor } from '../../../../../util/colorModule';

export function TJBoxConnectUpStream({
    up_stream,
    tjBoxCableConnectInfo,
    tjBoxConnectDispatch,
}) {
    const [cableInfo, setCableInfo] = useState(null);

    useEffect(() => {
        if (tjBoxCableConnectInfo.up_stream) {
            const fetchCableInfo = async () => {
                try {
                    const { data } = await axiosInstance.get(
                        `/cables/${tjBoxCableConnectInfo.up_stream}/detail`
                    );
                    setCableInfo(data);
                } catch (error) {
                    console.log(error);
                }
            };
            fetchCableInfo();
        }
    }, [setCableInfo, tjBoxCableConnectInfo.up_stream]);

    const handleUpStreamChange = (e) => {
        const up_stream_id = parseInt(e.target.value);
        tjBoxConnectDispatch({ type: 'SET_UP_STREAM', up_stream_id });
    };

    const handleUpStreamTubeChange = (e) => {
        const up_stream_tube_id = parseInt(e.target.value);
        tjBoxConnectDispatch({ type: 'SET_UP_STREAM_TUBE', up_stream_tube_id });
    };

    const handleUpStreamFiberChange = (e) => {
        const up_stream_fiber_id = parseInt(e.target.value);
        tjBoxConnectDispatch({
            type: 'SET_UP_STREAM_FIBER',
            up_stream_fiber_id,
        });
    };
    return (
        <Col lg={6}>
            <Form.Group>
                <Form.Label>Up Stream Cable</Form.Label>
                <Form.Select onChange={handleUpStreamChange}>
                    <option>Select Upstream Cable</option>
                    {up_stream.map((cable) => {
                        return (
                            <option value={cable.id} key={cable.id}>
                                {cable.id}. {cable.name}
                            </option>
                        );
                    })}
                </Form.Select>
            </Form.Group>
            {cableInfo && (
                <Form.Group>
                    <Form.Label>Up Stream Tube</Form.Label>
                    <Form.Select onChange={handleUpStreamTubeChange}>
                        <option>Select Upstream Tube</option>
                        {cableInfo.tubes.map((tube) => {
                            return (
                                <option value={tube.id} key={tube.id}>
                                    {tube.tube_number}.{' '}
                                    {getColor(tube.tube_number)}
                                </option>
                            );
                        })}
                    </Form.Select>
                </Form.Group>
            )}

            {tjBoxCableConnectInfo.up_stream_tube && (
                <Form.Group>
                    <Form.Label>Up Stream Fiber</Form.Label>
                    <Form.Select onChange={handleUpStreamFiberChange}>
                        <option>Select Upstream Fiber</option>
                        {cableInfo?.tubes
                            .find(
                                (tube) =>
                                    tube.id ===
                                    tjBoxCableConnectInfo.up_stream_tube
                            )
                            ?.fibers.map((fiber) => {
                                return (
                                    <option value={fiber.id} key={fiber.id}>
                                        {fiber.fiber_number}.{' '}
                                        {getColor(fiber.fiber_number)}{' '}
                                        {fiber.child_fiber ||
                                        fiber.child_component
                                            ? ' - Used'
                                            : ' - Available'}
                                    </option>
                                );
                            })}
                    </Form.Select>
                </Form.Group>
            )}
        </Col>
    );
}
