@extends('layout.app')

@push('styles')
    <link href="{{ asset('css/dashboard.css') }}" rel="stylesheet">
@endpush


@section('content')
    <section class="top-info-area">
        <div class="row">
            <div class="col-lg-3 col-md-4">
                <div class="bg-white profile-area">
                    <div class="title-area d-flex justify-content-between">
                        <span class="profile-text">Profile</span>
                        <div class="notification-and-refresh-area d-flex align-items-center">
                            <button class="refresh-button">Refresh</button>
                            <div class="ml-2">
                                <img src="{{ asset('images/dashboard_icon/notification.png') }}" alt="notification icon">
                                <span class="notification-value">
                                    0
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="mt-2 text-center">
                        <img src="{{ asset('images/dashboard_icon/profile_banner.jpg') }}" class="img-fluid"
                            alt="profile banner">
                        <img src="{{ asset('images/dashboard_icon/profile_image.png') }}" class="profile-picture img-fluid"
                            alt="">
                    </div>
                    <div class="mt-2 d-flex justify-content-around">
                        <div class="text-center">
                            <a href="">
                                <i class="fas fa-exchange-alt profile-area-icon"></i>
                                <p class="profile-area-text-icon-text mt-1">Password Change</p>
                            </a>
                        </div>
                        <div class="line">
                        </div>
                        <div class="text-center">
                            <a href="">
                                <i class="fas fa-sign-out-alt profile-area-icon"></i>
                                <p class="profile-area-text-icon-text mt-1">Logout</p>
                            </a>
                        </div>
                    </div>
                    <div class="text-center my-3 ">
                        <a href="" class="edit-profile-button text-white d-inline-block"><i
                                class="far fa-edit mr-1"></i>
                            Edit
                            Profile</a>
                    </div>
                </div>

            </div>
            <div class="col-lg-9">
                gRAPH AREA
            </div>
        </div>
    </section>

    <section class="detail-area bg-white mt-3 px-3">
        <div class="row g-3">
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorSky detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/1.png') }}" class="img-fluid"
                                    alt="">
                            </div>

                        </div>
                        <p class="mt-2 text-white text-center">Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorBlue detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/2.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Active Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorGreen detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/3.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Deactive Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorGray detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/4.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">New Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorPurple detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/5.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Expire Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorRed detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/6.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Panding Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorYellow detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/7.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Today Expense </p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorGray detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/8.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">September Bill
                            2022</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorYellow detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/9.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">September COL
                            2022</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorRed detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/10.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Total Bill COL</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorPurple detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/11.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Total Dues</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorGreen detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/12.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Open Tokens</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorBlue detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/13.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Closed Clients</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorSky detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/14.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">September 2022</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorSky detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/15.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Today Income</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorGreen detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/16.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Today Income</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorGray detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/17.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Total Income</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorBlue detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/18.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Total Expense</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorPurple detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/19.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Closed Tokens</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorRed detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/20.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">Open Tokens</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-2 col-lg-3 col-md-4">
                <a href="">
                    <div class="colorYellow detail-card">
                        <div class="text-center">
                            <div class="detail-icon">
                                <img src="{{ asset('images/dashboard_icon/icons/21.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                        </div>
                        <p class="mt-2 text-white text-center">October 2022</p>
                        <p class="mt-1 text-white fw-bold h4 text-center">20k</p>
                        <div class="text-right">
                            <i class="fas fa-arrow-right mr-3 mb-2 text-white"></i>
                        </div>
                    </div>
                </a>
            </div>


        </div>
    </section>

    <section class="row m-1">
        <div class="col-lg-12 col-xl-6">
            <div class="bg-white my-3 p-3 box-card row g-1">
                <div class="col-lg-3 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/1.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Area</p>
                        <p class="text-bold m-2">11.1km</p>
                        <div class="py-1 colorRed">
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/4.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Token</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorPurple">
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/3.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Closed</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorYellow">
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/2.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Panding</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorBlue">
                        </div>
                    </div>
                </div>




            </div>
        </div>
        <div class="col-lg-12 col-xl-3">
            <div class="bg-white my-3 mx-2 p-3 box-card row">
                <div class="col-lg-4 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/1.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Area</p>
                        <p class="text-bold m-2">11.1km</p>
                        <div class="py-1 colorRed">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/5.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Date</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorPurple">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/6.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Open</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorYellow">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-xl-3">
            <div class="bg-white my-3 p-3 box-card row g-1">
                <div class="col-lg-4 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/7.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Name</p>
                        <p class="text-bold m-2">____</p>
                        <div class="py-1 colorRed">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/4.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Token</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorPurple">
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 p-0">
                    <div class="text-center box-card-item pt-2 m-2">
                        <img src="{{ asset('images/dashboard_icon/box-icons/3.svg') }}" class="img-fluid mb-2"
                            alt="">
                        <p class="text-bold my-1">Closed</p>
                        <p class="text-bold m-2">11.1k</p>
                        <div class="py-1 colorYellow">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="bill-collection-area bg-white pt-2 px-4">
        <h4 class="text-center my-2">Report of Monthly Generated Bill Collection September 2022</h4>
        <table class="table table-hover table-responsive-lg">
            <thead>
                <tr>
                    <th scope="col" class="h6">Clients</th>
                    <th scope="col" class="h6">Billed Clients</th>
                    <th scope="col" class="h6">Bill Amount</th>
                    <th scope="col" class="h6">Received ID</th>
                    <th scope="col" class="h6">Received Amount</th>
                    <th scope="col" class="h6">COL. %</th>
                    <th scope="col" class="h6">Dues Clients</th>
                    <th scope="col" class="h6">Dues Amount</th>
                    <th scope="col" class="h6">Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6">23</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">21</td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6">5</td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6">23</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">21</td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6">5</td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6">23</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">21</td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6">5</td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6">23</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">21</td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6">5</td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6">23</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">21</td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6">5</td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6">23</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">21</td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6">5</td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
            </tbody>
        </table>
    </section>

    <section class="bill-collection-area bg-white pt-2 px-4">
        <h4 class="text-center my-2">Report of New, Package & Billing Cycle Change Bill Collection September 2022</h4>
        <table class="table table-hover table-responsive-lg">
            <thead>
                <tr>
                    <th scope="col" class="h6">Clients</th>
                    <th scope="col" class="h6">Bill Amount</th>
                    <th scope="col" class="h6">Received Amount</th>
                    <th scope="col" class="h6">COL. %</th>
                    <th scope="col" class="h6">Dues Amount</th>
                    <th scope="col" class="h6">Total</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
                <tr>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">14</td>
                    <td class="h6"><span class="text-success">12.4%</span></td>
                    <td class="h6"><span class="text-primary">12</span></td>
                    <td class="h6">2100</td>
                </tr>
            </tbody>
        </table>
    </section>

    <section class="bill-collection-area bg-white pt-2 p-4">
        <table class="table table-hover table-responsive-lg">
            <thead>
                <tr>
                    <th scope="col" class="h6">Clients ID</th>
                    <th scope="col" class="h6">Client Name</th>
                    <th scope="col" class="h6">Balance</th>
                    <th scope="col" class="h6">POP</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="h6">#YL1415</td>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">
                        <div class="row my-2">
                            <div class="col">
                                <span>Jansh Brown</span>
                            </div>
                            <div class="col">
                                <span class="text-primary">12</span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <span>Jansh Brown</span>
                            </div>
                            <div class="col">
                                <span class="text-primary">12</span>
                            </div>
                        </div>
                    </td>

                </tr>
                <tr>
                    <td class="h6">#YL1415</td>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">
                        <div class="row my-2">
                            <div class="col">
                                <span>Jansh Brown</span>
                            </div>
                            <div class="col">
                                <span class="text-primary">12</span>
                            </div>
                        </div>
                    </td>

                </tr>
                <tr>
                    <td class="h6">#YL1415</td>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">
                        <div class="row my-2">
                            <div class="col">
                                <span>Jansh Brown</span>
                            </div>
                            <div class="col">
                                <span class="text-primary">12</span>
                            </div>
                        </div>
                    </td>

                </tr>
                <tr>
                    <td class="h6">#YL1415</td>
                    <td class="h6">Alex Smith</td>
                    <td class="h6"><span class="bg-danger py-1 px-3 rounded">2100</span></td>
                    <td class="h6">
                        <div class="row my-2">
                            <div class="col">
                                <span>Jansh Brown</span>
                            </div>
                            <div class="col">
                                <span class="text-primary">12</span>
                            </div>
                        </div>
                    </td>

                </tr>
            </tbody>
        </table>
    </section>
@endsection
