<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application. This value is used when the
    | framework needs to place the application's name in a notification or
    | any other location as required by the application or its packages.
    |
    */

    'name' => env('APP_NAME', 'Laravel'),
    'office_number' => env('APP_OFFICE_NUMBER', ''),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services the application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => (bool) env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url' => env('APP_URL', 'http://radius.yetfix.com'),

    'asset_url' => env('ASSET_URL', null),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone' => 'Asia/Dhaka',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Faker Locale
    |--------------------------------------------------------------------------
    |
    | This locale will be used by the Faker PHP library when generating fake
    | data for your database seeds. For example, this will be used to get
    | localized telephone numbers, street address information and more.
    |
    */

    'faker_locale' => 'en_US',

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key' => env('APP_KEY'),

    'cipher' => 'AES-256-CBC',

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'daily_pricing' => env('DAILY_PRICING', true),
    'smsApiUrl' => env('SMSAPIURL'),
    'smsApiKey' => env('SMSAPIKEY'),
    'theme_folder' => env('THEME_TYPE'),

    'nagad_secret' => env('NAGAD_SECRET'),
    'nagad_app' => env('NAGAD_APP_KEY'),

    'bkash_secret' => env('BKASH_SECRET'),
    'bkash_app' => env('BKASH_APP_KEY'),

    'billing_cycle' => env('BILLING_CYCLE', '1,7,11,14,21'),


    'billing_day_count' => env('BILLING_DAY_COUNT', false),

    // this is for auto payment when billing or packae change is done

    'bill_or_package_change_auto_payment' => env('BILL_OR_PKG_CNG_AUTO_PAYMENT', false),


    'only_monthly_bill_show' => env('ONLY_MONTHLY_BILL_SHOW', false),

    'full_month_bill_for_new_customer' => env('FULL_MONTH_BILL_FOR_NEW_CUSTOMER', false),

    // this is for auto payment when new customer created
    'on_create_customer_auto_payment' => env('ON_CREATE_CUSTOMER_AUTO_PAYMENT', 'default'),


    // if false then otc will be marked as paid

    'otc_auto_due' => env('OTC_AUTO_DUE', false),


    //if false then otc amount not will add in customer account

    'otc_added_to_customer_account' => env('OTC_AUTO_DUE', false),


    'set_full_package_price_on_new_customer_create' => env('SET_FULL_PACKAGE_PRICE_ON_NEW_CUSTOMER_CREATE', false),
    'customer_id_show_on_create' => env('CUSTOMER_ID_INSERT_OPTION_SHOW', false),

    'sms_api' => env('SMSAPI'),
    'sms_api_key' => env('SMS_API_KEY'),
    'sms_sender' => env('SMS_SENDER_NUMBER'),

    'TokenClientMessage' => env('TokenClientMessage'),
    'TokenAssignedMessageToClient' => env('TokenAssignedMessageToClient'),
    'TokenAssignedMessageToAgent' => env('TokenAssignedMessageToAgent'),

    'tokenSmsSend' => env('TOKEN_SMS_SEND', false),

    'reseller_custome_paid_option' => env('RESELLER_CUSTOM_PAID', false),

    'license_check' => env('CLIENT_LICENSE_CHECK', false),
    'license_check_time' => env('CLIENT_LICENSE_CHECK_TIME', 30),

    'bkash_app_key'          => env('BKASH_PGW_APP_KEY'),
    'bkash_app_secret'       => env('BKASH_PGW_SECRET_KEY'),
    'bkash_username'         => env('BKASH_PGW_USERNAME'),
    'bkash_password'         => env('BKASH_PGW_PASSWORD'),
    'bksh_base_url'          => env('BKASH_PGW_URL'),
    'bkash_payerReference'   => env('BKASH_PGW_PAYER_REFERENCE'),
    'bkash_callbackurl'      => env('BKASH_PGW_CALLBACK_URL'),
    'bkash_live_script'      => env('BKASH_PGW_LIVE_SCRIPT'),

    "nagad_merchant_id"     => env("NAGAD_MERCHANT_ID", ""),
    "nagad_merchant_number" => env("NAGAD_MERCHANT_NUMBER", ""),
    "nagad_public_key"      => env("NAGAD_PUBLIC_KEY", ""),
    "nagad_private_key"     => env("NAGAD_PRIVATE_KEY", ""),
    'timezone'             => 'Asia/Dhaka',
    "nagad_callbackurl"    => env("NAGAD_CALLBACK_URL"),
    "nagad_base_url"       => env("NAGAD_BASE_URL"),
    "nagad_reseller_recharge_callbackurl"       => env("NAGAD_RESELLER_CALLBACK_URL"),
    "nagad_pop_recharge_callbackurl"       => env("NAGAD_POP_CALLBACK_URL"),
    'rocket_app_key'          => env('ROCKET_APP_KEY'),
    'rocket_app_secret'       => env('ROCKET_SECRET'),

    /*surjopay start*/

    /*surjopay start*/

    /*surjopay end*/

    // EPS PGW
    'EPS_BASE_URL'          => env('EPS_BASE_URL'),
    'EPS_USERNAME'          => env('EPS_USERNAME'),
    'EPS_PASSWORD'          => env('EPS_PASSWORD'),
    'EPS_DEVICE_TYPE_ID'    => env('EPS_DEVICE_TYPE_ID'),
    'EPS_HASH_KEY'          => env('EPS_HASH_KEY'),
    'EPS_MERCHANT_ID'       => env('EPS_MERCHANT_ID'),
    'EPS_STORE_ID'          => env('EPS_STORE_ID'),
    'EPS_CALLBACK_URL'      => env('EPS_CALLBACK_URL'),

    'providers' => [

        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        Illuminate\Database\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        Illuminate\Filesystem\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Mail\MailServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        Illuminate\Session\SessionServiceProvider::class,
        Illuminate\Translation\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,
        Illuminate\View\ViewServiceProvider::class,
        Barryvdh\Debugbar\ServiceProvider::class,
        Yajra\DataTables\DataTablesServiceProvider::class,
        Spatie\Permission\PermissionServiceProvider::class,

        /*
         * Package Service Providers...
         */

        /*
         * Application Service Providers...
         */
        App\Providers\AppServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        App\Providers\BroadcastServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\RouteServiceProvider::class,
        niklasravnsborg\LaravelPdf\PdfServiceProvider::class,
        Maatwebsite\Excel\ExcelServiceProvider::class,
        Bugsnag\BugsnagLaravel\BugsnagServiceProvider::class,

        App\Providers\RadPostAuthServiceProvider::class,



    ],

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases' => [

        'App' => Illuminate\Support\Facades\App::class,
        'Arr' => Illuminate\Support\Arr::class,
        'Artisan' => Illuminate\Support\Facades\Artisan::class,
        'Auth' => Illuminate\Support\Facades\Auth::class,
        'Blade' => Illuminate\Support\Facades\Blade::class,
        'Broadcast' => Illuminate\Support\Facades\Broadcast::class,
        'Bus' => Illuminate\Support\Facades\Bus::class,
        'Cache' => Illuminate\Support\Facades\Cache::class,
        'Config' => Illuminate\Support\Facades\Config::class,
        'Cookie' => Illuminate\Support\Facades\Cookie::class,
        'Crypt' => Illuminate\Support\Facades\Crypt::class,
        'DB' => Illuminate\Support\Facades\DB::class,
        'Eloquent' => Illuminate\Database\Eloquent\Model::class,
        'Event' => Illuminate\Support\Facades\Event::class,
        'File' => Illuminate\Support\Facades\File::class,
        'Gate' => Illuminate\Support\Facades\Gate::class,
        'Hash' => Illuminate\Support\Facades\Hash::class,
        'Http' => Illuminate\Support\Facades\Http::class,
        'Lang' => Illuminate\Support\Facades\Lang::class,
        'Log' => Illuminate\Support\Facades\Log::class,
        'Mail' => Illuminate\Support\Facades\Mail::class,
        'Notification' => Illuminate\Support\Facades\Notification::class,
        'Password' => Illuminate\Support\Facades\Password::class,
        'Queue' => Illuminate\Support\Facades\Queue::class,
        'Redirect' => Illuminate\Support\Facades\Redirect::class,
        // 'Redis' => Illuminate\Support\Facades\Redis::class,
        'Request' => Illuminate\Support\Facades\Request::class,
        'Response' => Illuminate\Support\Facades\Response::class,
        'Route' => Illuminate\Support\Facades\Route::class,
        'Schema' => Illuminate\Support\Facades\Schema::class,
        'Session' => Illuminate\Support\Facades\Session::class,
        'Storage' => Illuminate\Support\Facades\Storage::class,
        'Str' => Illuminate\Support\Str::class,
        'URL' => Illuminate\Support\Facades\URL::class,
        'Validator' => Illuminate\Support\Facades\Validator::class,
        'View' => Illuminate\Support\Facades\View::class,
        'DataTables' => Yajra\DataTables\Facades\DataTables::class,
        'TopmenuService'   => App\Services\TopmenuService::class,
        'PDF' => niklasravnsborg\LaravelPdf\Facades\Pdf::class,
        'Excel' => Maatwebsite\Excel\Facades\Excel::class,
        'Bugsnag' => Bugsnag\BugsnagLaravel\Facades\Bugsnag::class,

        'splitter' => App\Models\map\Splitter::class,
        'port' => App\Models\map\Port::class,
        "splitter_out" => App\Models\map\SplitterOut::class,
        'onu' => App\Models\map\Onu::class,
        'client' => App\Models\Clientsinfo::class,
        "cluster" => App\Models\map\Cluster::class,
        "tjBox" => App\Models\map\TjBox::class,

        "RadPostAuth" => App\Facades\RadPostAuthFacade::class


    ],

];
