@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('employees.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="user_id">
                            Application User ID <span style="color: red">*</span>
                        </label>

                        <input type="number" name="user_id" id="user_id" value="{{ old('user_id') }}"
                            class="form-control" placeholder="User ID" autocomplete="off" required>

                        @error('user_id')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror

                    </div>

                    <div class="form-group col-md-4">
                        <label for="name">
                            Employee Name <span style="color: red">*</span>
                        </label>
                        <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control"
                            placeholder="Employee Name" autocomplete="off" required>
                        @error('name')
                            <div class="alert alert-danger">
                                {{ $message }}</div>
                        @enderror

                    </div>

                    <div class="form-group col-md-4">
                        <label for="current_designation">
                            Designation
                        </label>

                        <input type="text" name="current_designation" id="current_designation" class="form-control"
                            placeholder="Designation" value="{{ old('current_designation') }}" autocomplete="off">

                        @error('current_designation')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="mobile_office">
                            Mobile Number <span style="color: red">*</span>
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">
                            <input type="text" name="mobile_office" id="mobile_office" class="form-control"
                                placeholder="Mobile Number" value="" autocomplete="off" required>
                        </div>
                        @error('mobile_office')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="from_date">
                            Join Date <span style="color: red">*</span>
                        </label>
                        <div class="input-group date" id="searchFrom" data-target-input="nearest">
                            <input type="text" name="join_date" class="form-control datetimepicker-input input-group-append" required
                                data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off" value="{{ old('join_date') }}">

                        </div>

                        @error('join_date')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="manager_id">
                            Manager ID
                        </label>
                        <input type="number" name="manager_id" id="manager_id" class="form-control"
                            placeholder="Manager ID" value="{{ old('manager_id') }}" autocomplete="off">
                        @error('manager_id')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="status">
                            Status <span style="color: red">*</span>
                        </label>
                        <select name="status" id="status" class="form-control select2" required>
                            <option value="">Select Status</option>
                            <option value="active">Active</option>
                            <option value="pending">Pending</option>
                        </select>
                    </div>
                </div>
                <div class="form-group float-right">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i> Save</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>

            </form>

        </div>
    </div>
@endsection
