@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>
            <div class="table-responsive">
                <table id="dataTable" class="display table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Employee Id</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Salary</th>
                            <th>Home Allowance</th>
                            <th>TA/DA Allowance</th>
                            <th>Other Allowance</th>
                            <th>Bonous</th>
                            <th>Deduction</th>
                            <th>Net Salary</th>
                            <th>Have Salary</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($salarySheets as $salarySheet)
                            <tr>
                                {{-- @dd($salarySheet) --}}
                                <td>{{ $salarySheet->employee_id }}</td>
                                <td>{{ $salarySheet->employee->name }}</td>
                                <td>{{ $salarySheet->employee->email }}</td>
                                <td>{{ $salarySheet->salary }}</td>
                                <td>{{ $salarySheet->home_allowance }}</td>
                                <td>{{ $salarySheet->transport_allowance }}</td>
                                <td>{{ $salarySheet->other_allowance }}</td>
                                <td>{{ $salarySheet->bonous }}</td>
                                <td>{{ $salarySheet->deduction }}</td>
                                <td>{{ $salarySheet->net_salary }}</td>
                                <td>{{ $salarySheet->salary_amount }}</td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>

        </div>
    </div>




    <script>
        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#dataTable tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                    // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
                    if ((index + 1) % 3 === 0) {
                        rowData.push('"' + column.innerText + '"');
                    } else {
                        rowData.push(column.innerText.replace(',', ''));
                    }
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");
            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([data], {
                type: "text/csv"
            }));
            a.setAttribute("download", "Employee Salary.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
    </script>
@endsection
