<div class="mb-2">
    <button class="btn btn-primary" onclick="export2csv()">Download csv</button>
</div>
<div class="col-md-12">
    <div class="badge badge-info float-right m-1" style="text-align: ">Total Row: {{ $list->count() }}</div>
</div>
<div class="table-responsive">
    <table class="table table-bordered table-condensed table-striped" id="tableId">
        <thead class="bg-blue-50">
            <tr>
                <th> SL </th>
                <th> Invoice </th>
                <th> Document </th>
                <th> Provider </th>
                <th> Billing Date </th>
                <th> Total </th>
                <th> Paid </th>
                <th> Due </th>
                <th style="width: 100px; "> Action </th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            @php
                $total = 0;
                $paid = 0;
                $due = 0;
            @endphp
            @foreach ($list as $item)
                <tr>
                    <td>{{ $item->id }}</td>
                    <td>{{ $item->invoice_no }}</td>
                    <td>
                        <img src="{{ asset('storage/bandPurchase/' . $item->document) }}"
                            style="width: 90px; height: 50px;">
                    </td>
                    <td>{{ $item->provider->company_name ?? '' }}</td>
                    <td>{{ $item->billing_date }}</td>
                    <td style="text-align: right">{{ $item->total_price }}</td>
                    <td style="text-align: right">{{ $item->paid }}</td>
                    <td style="text-align: right">
                        @php
                            $d_amount = $item->total_price - $item->paid;
                        @endphp
                        {{ number_format($d_amount, 2) }}
                    </td>
                    @php
                        $total += $item->total_price;
                        $paid += $item->paid;
                        $due += $item->total_price - $item->paid;
                    @endphp
                    <td>
                        <div class="row">
                            <div class="ml-1">
                                <a href="{{ route('band-purchase.edit', $item->id) }}"
                                    class="form-control btn btn-warning">Edit</a>
                            </div>
                        </div>
                    </td>
                </tr>
            @endforeach
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td style="text-align: right"><b>Total</b></td>
                <td style="text-align: right"><b>{{ number_format($total, 2) }}</b></td>
                <td style="text-align: right"><b>{{ number_format($paid, 2) }}</b></td>
                <td style="text-align: right"><b>{{ number_format($due, 2) }}</b></td>
                <td></td>
            </tr>
        </tbody>
    </table>
</div>
