<?php

namespace App\Http\Controllers;

use App\Models\OltInfo;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Mpdf\Tag\Ol;

class OltInfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('oltinfo.index',[
            'page_title' => 'OLT Information',
            'oltinfos' => OltInfo::all()
        ]);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('oltinfo.create',[
            'page_title' => 'Create OLT Information'
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'olt_address' => 'required',
            'community' => 'required',
            'port' => 'required',
            'olt_company' => 'required',
            'olt_type' => 'required'
        ]);

        $oltInfo = new OltInfo();
        $oltInfo->olt_address = $request->olt_address;
        $oltInfo->community = $request->community;
        if($request->olt_company == 'BDCom'){
            $oltInfo->olt_name = 'iso.3.6.1.2.1.1.5.0';
            $oltInfo->vlan_mac = 'SNMPv2-SMI::mib-2.17.7.1.2.2.1.1';
            $oltInfo->onu_id = 'SNMPv2-SMI::mib-2.17.7.1.2.2.1.2';
            $oltInfo->onu_interface_name = 'IF-MIB::ifDescr';
            if($request->olt_type == 'Epon'){
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.3320.101.10.5.1.5';
            }else{
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.3320.10.3.4.1.2';
            }

        }else{
            $oltInfo->olt_name = 'iso.3.6.1.2.1.1.5.0';

            if($request->olt_type == 'Epon'){
                $oltInfo->vlan_mac = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.2.1.3';
                $oltInfo->onu_id = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.2.1.5';
                $oltInfo->onu_interface_name = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.2.1.5';
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.37950.1.1.5.12.2.1.8.1.7';
            }else{
                $oltInfo->vlan_mac = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.5.1.3';
                $oltInfo->onu_id = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.5.1.5';
                $oltInfo->onu_interface_name = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.5.1.5';
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.37950.1.1.6.1.1.3.1.7';
            }
        }

        $oltInfo->port = $request->port;
        $oltInfo->olt_company = $request->olt_company;
        $oltInfo->olt_type = $request->olt_type;
        $oltInfo->save();

        Toastr::success('OLT Information Created Successfully');
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\OltInfo  $oltInfo
     * @return \Illuminate\Http\Response
     */
    public function show(OltInfo $oltInfo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\OltInfo  $oltInfo
     * @return \Illuminate\Http\Response
     */
    public function edit(OltInfo $oltInfo, $id)
    {
        return view('oltinfo.edit',[
            'page_title' => 'Edit OLT Information',
            'oltinfo' => OltInfo::find($id)->first()
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\OltInfo  $oltInfo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, OltInfo $oltInfo, $id)
    {
        $request->validate([
            'olt_address' => 'required',
            'community' => 'required',
            'port' => 'required',
            'olt_company' => 'required',
            'olt_type' => 'required'
        ]);

        $oltInfo = OltInfo::find($id);
        $oltInfo->olt_address = $request->olt_address;
        $oltInfo->community = $request->community;
        if($request->olt_company == 'BDCom'){
            $oltInfo->olt_name = 'iso.3.6.1.2.1.1.5.0';
            $oltInfo->vlan_mac = 'SNMPv2-SMI::mib-2.17.7.1.2.2.1.1';
            $oltInfo->onu_id = 'SNMPv2-SMI::mib-2.17.7.1.2.2.1.2';
            $oltInfo->onu_interface_name = 'IF-MIB::ifDescr';
            if($request->olt_type == 'Epon'){
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.3320.101.10.5.1.5';
            }else{
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.3320.10.3.4.1.2';
            }

        }else{
            $oltInfo->olt_name = 'iso.3.6.1.2.1.1.5.0';

            if($request->olt_type == 'Epon'){
                $oltInfo->vlan_mac = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.2.1.3';
                $oltInfo->onu_id = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.2.1.5';
                $oltInfo->onu_interface_name = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.2.1.5';
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.37950.1.1.5.12.2.1.8.1.7';
            }else{
                $oltInfo->vlan_mac = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.5.1.3';
                $oltInfo->onu_id = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.5.1.5';
                $oltInfo->onu_interface_name = 'SNMPv2-SMI::enterprises.37950.1.1.5.10.3.5.1.5';
                $oltInfo->onu_laser = 'SNMPv2-SMI::enterprises.37950.1.1.6.1.1.3.1.7';
            }
        }

        $oltInfo->port = $request->port;
        $oltInfo->olt_company = $request->olt_company;
        $oltInfo->olt_type = $request->olt_type;
        $oltInfo->save();

        Toastr::success('OLT Information Updated Successfully');
        return redirect()->route('oltinfo.index');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\OltInfo  $oltInfo
     * @return \Illuminate\Http\Response
     */
    public function destroy(OltInfo $oltInfo, $id)
    {
        OltInfo::find($id)->delete();
        Toastr::success('OLT Information Deleted Successfully');
        return back();
    }
}
